/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the location of ML model data to deploy. If specified, you must specify one and only one of the available
 * data sources.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDataSource implements SdkPojo, Serializable, ToCopyableBuilder<ModelDataSource.Builder, ModelDataSource> {
    private static final SdkField<S3ModelDataSource> S3_DATA_SOURCE_FIELD = SdkField
            .<S3ModelDataSource> builder(MarshallingType.SDK_POJO).memberName("S3DataSource")
            .getter(getter(ModelDataSource::s3DataSource)).setter(setter(Builder::s3DataSource))
            .constructor(S3ModelDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3ModelDataSource s3DataSource;

    private ModelDataSource(BuilderImpl builder) {
        this.s3DataSource = builder.s3DataSource;
    }

    /**
     * <p>
     * Specifies the S3 location of ML model data to deploy.
     * </p>
     * 
     * @return Specifies the S3 location of ML model data to deploy.
     */
    public final S3ModelDataSource s3DataSource() {
        return s3DataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDataSource)) {
            return false;
        }
        ModelDataSource other = (ModelDataSource) obj;
        return Objects.equals(s3DataSource(), other.s3DataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDataSource").add("S3DataSource", s3DataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3DataSource":
            return Optional.ofNullable(clazz.cast(s3DataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelDataSource, T> g) {
        return obj -> g.apply((ModelDataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDataSource> {
        /**
         * <p>
         * Specifies the S3 location of ML model data to deploy.
         * </p>
         * 
         * @param s3DataSource
         *        Specifies the S3 location of ML model data to deploy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataSource(S3ModelDataSource s3DataSource);

        /**
         * <p>
         * Specifies the S3 location of ML model data to deploy.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3ModelDataSource.Builder} avoiding the
         * need to create one manually via {@link S3ModelDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3ModelDataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DataSource(S3ModelDataSource)}.
         * 
         * @param s3DataSource
         *        a consumer that will call methods on {@link S3ModelDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataSource(S3ModelDataSource)
         */
        default Builder s3DataSource(Consumer<S3ModelDataSource.Builder> s3DataSource) {
            return s3DataSource(S3ModelDataSource.builder().applyMutation(s3DataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3ModelDataSource s3DataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDataSource model) {
            s3DataSource(model.s3DataSource);
        }

        public final S3ModelDataSource.Builder getS3DataSource() {
            return s3DataSource != null ? s3DataSource.toBuilder() : null;
        }

        public final void setS3DataSource(S3ModelDataSource.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        @Override
        public final Builder s3DataSource(S3ModelDataSource s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        @Override
        public ModelDataSource build() {
            return new ModelDataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
