/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of a model as returned by the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Model implements SdkPojo, Serializable, ToCopyableBuilder<Model.Builder, Model> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(Model::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<ContainerDefinition> PRIMARY_CONTAINER_FIELD = SdkField
            .<ContainerDefinition> builder(MarshallingType.SDK_POJO).memberName("PrimaryContainer")
            .getter(getter(Model::primaryContainer)).setter(setter(Builder::primaryContainer))
            .constructor(ContainerDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryContainer").build()).build();

    private static final SdkField<List<ContainerDefinition>> CONTAINERS_FIELD = SdkField
            .<List<ContainerDefinition>> builder(MarshallingType.LIST)
            .memberName("Containers")
            .getter(getter(Model::containers))
            .setter(setter(Builder::containers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Containers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ContainerDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ContainerDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<InferenceExecutionConfig> INFERENCE_EXECUTION_CONFIG_FIELD = SdkField
            .<InferenceExecutionConfig> builder(MarshallingType.SDK_POJO).memberName("InferenceExecutionConfig")
            .getter(getter(Model::inferenceExecutionConfig)).setter(setter(Builder::inferenceExecutionConfig))
            .constructor(InferenceExecutionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceExecutionConfig").build())
            .build();

    private static final SdkField<String> EXECUTION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionRoleArn").getter(getter(Model::executionRoleArn)).setter(setter(Builder::executionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRoleArn").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(Model::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Model::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(Model::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableNetworkIsolation").getter(getter(Model::enableNetworkIsolation))
            .setter(setter(Builder::enableNetworkIsolation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Model::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DeploymentRecommendation> DEPLOYMENT_RECOMMENDATION_FIELD = SdkField
            .<DeploymentRecommendation> builder(MarshallingType.SDK_POJO).memberName("DeploymentRecommendation")
            .getter(getter(Model::deploymentRecommendation)).setter(setter(Builder::deploymentRecommendation))
            .constructor(DeploymentRecommendation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentRecommendation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            PRIMARY_CONTAINER_FIELD, CONTAINERS_FIELD, INFERENCE_EXECUTION_CONFIG_FIELD, EXECUTION_ROLE_ARN_FIELD,
            VPC_CONFIG_FIELD, CREATION_TIME_FIELD, MODEL_ARN_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, TAGS_FIELD,
            DEPLOYMENT_RECOMMENDATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final ContainerDefinition primaryContainer;

    private final List<ContainerDefinition> containers;

    private final InferenceExecutionConfig inferenceExecutionConfig;

    private final String executionRoleArn;

    private final VpcConfig vpcConfig;

    private final Instant creationTime;

    private final String modelArn;

    private final Boolean enableNetworkIsolation;

    private final List<Tag> tags;

    private final DeploymentRecommendation deploymentRecommendation;

    private Model(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.primaryContainer = builder.primaryContainer;
        this.containers = builder.containers;
        this.inferenceExecutionConfig = builder.inferenceExecutionConfig;
        this.executionRoleArn = builder.executionRoleArn;
        this.vpcConfig = builder.vpcConfig;
        this.creationTime = builder.creationTime;
        this.modelArn = builder.modelArn;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.tags = builder.tags;
        this.deploymentRecommendation = builder.deploymentRecommendation;
    }

    /**
     * <p>
     * The name of the model.
     * </p>
     * 
     * @return The name of the model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * Returns the value of the PrimaryContainer property for this object.
     * 
     * @return The value of the PrimaryContainer property for this object.
     */
    public final ContainerDefinition primaryContainer() {
        return primaryContainer;
    }

    /**
     * For responses, this returns true if the service returned a value for the Containers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContainers() {
        return containers != null && !(containers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The containers in the inference pipeline.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainers} method.
     * </p>
     * 
     * @return The containers in the inference pipeline.
     */
    public final List<ContainerDefinition> containers() {
        return containers;
    }

    /**
     * Returns the value of the InferenceExecutionConfig property for this object.
     * 
     * @return The value of the InferenceExecutionConfig property for this object.
     */
    public final InferenceExecutionConfig inferenceExecutionConfig() {
        return inferenceExecutionConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that you specified for the model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that you specified for the model.
     */
    public final String executionRoleArn() {
        return executionRoleArn;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * A timestamp that indicates when the model was created.
     * </p>
     * 
     * @return A timestamp that indicates when the model was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * Isolates the model container. No inbound or outbound network calls can be made to or from the model container.
     * </p>
     * 
     * @return Isolates the model container. No inbound or outbound network calls can be made to or from the model
     *         container.
     */
    public final Boolean enableNetworkIsolation() {
        return enableNetworkIsolation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of key-value pairs associated with the model. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services resources</a>
     * in the <i>Amazon Web Services General Reference Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs associated with the model. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A set of recommended deployment configurations for the model.
     * </p>
     * 
     * @return A set of recommended deployment configurations for the model.
     */
    public final DeploymentRecommendation deploymentRecommendation() {
        return deploymentRecommendation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(primaryContainer());
        hashCode = 31 * hashCode + Objects.hashCode(hasContainers() ? containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(inferenceExecutionConfig());
        hashCode = 31 * hashCode + Objects.hashCode(executionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deploymentRecommendation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Model)) {
            return false;
        }
        Model other = (Model) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(primaryContainer(), other.primaryContainer())
                && hasContainers() == other.hasContainers() && Objects.equals(containers(), other.containers())
                && Objects.equals(inferenceExecutionConfig(), other.inferenceExecutionConfig())
                && Objects.equals(executionRoleArn(), other.executionRoleArn()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(enableNetworkIsolation(), other.enableNetworkIsolation()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && Objects.equals(deploymentRecommendation(), other.deploymentRecommendation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Model").add("ModelName", modelName()).add("PrimaryContainer", primaryContainer())
                .add("Containers", hasContainers() ? containers() : null)
                .add("InferenceExecutionConfig", inferenceExecutionConfig()).add("ExecutionRoleArn", executionRoleArn())
                .add("VpcConfig", vpcConfig()).add("CreationTime", creationTime()).add("ModelArn", modelArn())
                .add("EnableNetworkIsolation", enableNetworkIsolation()).add("Tags", hasTags() ? tags() : null)
                .add("DeploymentRecommendation", deploymentRecommendation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "PrimaryContainer":
            return Optional.ofNullable(clazz.cast(primaryContainer()));
        case "Containers":
            return Optional.ofNullable(clazz.cast(containers()));
        case "InferenceExecutionConfig":
            return Optional.ofNullable(clazz.cast(inferenceExecutionConfig()));
        case "ExecutionRoleArn":
            return Optional.ofNullable(clazz.cast(executionRoleArn()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "EnableNetworkIsolation":
            return Optional.ofNullable(clazz.cast(enableNetworkIsolation()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "DeploymentRecommendation":
            return Optional.ofNullable(clazz.cast(deploymentRecommendation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Model, T> g) {
        return obj -> g.apply((Model) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Model> {
        /**
         * <p>
         * The name of the model.
         * </p>
         * 
         * @param modelName
         *        The name of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * Sets the value of the PrimaryContainer property for this object.
         *
         * @param primaryContainer
         *        The new value for the PrimaryContainer property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryContainer(ContainerDefinition primaryContainer);

        /**
         * Sets the value of the PrimaryContainer property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ContainerDefinition.Builder} avoiding the
         * need to create one manually via {@link ContainerDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #primaryContainer(ContainerDefinition)}.
         * 
         * @param primaryContainer
         *        a consumer that will call methods on {@link ContainerDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primaryContainer(ContainerDefinition)
         */
        default Builder primaryContainer(Consumer<ContainerDefinition.Builder> primaryContainer) {
            return primaryContainer(ContainerDefinition.builder().applyMutation(primaryContainer).build());
        }

        /**
         * <p>
         * The containers in the inference pipeline.
         * </p>
         * 
         * @param containers
         *        The containers in the inference pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(Collection<ContainerDefinition> containers);

        /**
         * <p>
         * The containers in the inference pipeline.
         * </p>
         * 
         * @param containers
         *        The containers in the inference pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containers(ContainerDefinition... containers);

        /**
         * <p>
         * The containers in the inference pipeline.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ContainerDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.sagemaker.model.ContainerDefinition#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ContainerDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #containers(List<ContainerDefinition>)}.
         * 
         * @param containers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ContainerDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containers(java.util.Collection<ContainerDefinition>)
         */
        Builder containers(Consumer<ContainerDefinition.Builder>... containers);

        /**
         * Sets the value of the InferenceExecutionConfig property for this object.
         *
         * @param inferenceExecutionConfig
         *        The new value for the InferenceExecutionConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceExecutionConfig(InferenceExecutionConfig inferenceExecutionConfig);

        /**
         * Sets the value of the InferenceExecutionConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InferenceExecutionConfig.Builder}
         * avoiding the need to create one manually via {@link InferenceExecutionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceExecutionConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #inferenceExecutionConfig(InferenceExecutionConfig)}.
         * 
         * @param inferenceExecutionConfig
         *        a consumer that will call methods on {@link InferenceExecutionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceExecutionConfig(InferenceExecutionConfig)
         */
        default Builder inferenceExecutionConfig(Consumer<InferenceExecutionConfig.Builder> inferenceExecutionConfig) {
            return inferenceExecutionConfig(InferenceExecutionConfig.builder().applyMutation(inferenceExecutionConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that you specified for the model.
         * </p>
         * 
         * @param executionRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that you specified for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRoleArn(String executionRoleArn);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * A timestamp that indicates when the model was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that indicates when the model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * Isolates the model container. No inbound or outbound network calls can be made to or from the model
         * container.
         * </p>
         * 
         * @param enableNetworkIsolation
         *        Isolates the model container. No inbound or outbound network calls can be made to or from the model
         *        container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableNetworkIsolation(Boolean enableNetworkIsolation);

        /**
         * <p>
         * A list of key-value pairs associated with the model. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs associated with the model. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of key-value pairs associated with the model. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs associated with the model. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of key-value pairs associated with the model. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A set of recommended deployment configurations for the model.
         * </p>
         * 
         * @param deploymentRecommendation
         *        A set of recommended deployment configurations for the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentRecommendation(DeploymentRecommendation deploymentRecommendation);

        /**
         * <p>
         * A set of recommended deployment configurations for the model.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeploymentRecommendation.Builder}
         * avoiding the need to create one manually via {@link DeploymentRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeploymentRecommendation.Builder#build()} is called immediately
         * and its result is passed to {@link #deploymentRecommendation(DeploymentRecommendation)}.
         * 
         * @param deploymentRecommendation
         *        a consumer that will call methods on {@link DeploymentRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentRecommendation(DeploymentRecommendation)
         */
        default Builder deploymentRecommendation(Consumer<DeploymentRecommendation.Builder> deploymentRecommendation) {
            return deploymentRecommendation(DeploymentRecommendation.builder().applyMutation(deploymentRecommendation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private ContainerDefinition primaryContainer;

        private List<ContainerDefinition> containers = DefaultSdkAutoConstructList.getInstance();

        private InferenceExecutionConfig inferenceExecutionConfig;

        private String executionRoleArn;

        private VpcConfig vpcConfig;

        private Instant creationTime;

        private String modelArn;

        private Boolean enableNetworkIsolation;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private DeploymentRecommendation deploymentRecommendation;

        private BuilderImpl() {
        }

        private BuilderImpl(Model model) {
            modelName(model.modelName);
            primaryContainer(model.primaryContainer);
            containers(model.containers);
            inferenceExecutionConfig(model.inferenceExecutionConfig);
            executionRoleArn(model.executionRoleArn);
            vpcConfig(model.vpcConfig);
            creationTime(model.creationTime);
            modelArn(model.modelArn);
            enableNetworkIsolation(model.enableNetworkIsolation);
            tags(model.tags);
            deploymentRecommendation(model.deploymentRecommendation);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final ContainerDefinition.Builder getPrimaryContainer() {
            return primaryContainer != null ? primaryContainer.toBuilder() : null;
        }

        public final void setPrimaryContainer(ContainerDefinition.BuilderImpl primaryContainer) {
            this.primaryContainer = primaryContainer != null ? primaryContainer.build() : null;
        }

        @Override
        public final Builder primaryContainer(ContainerDefinition primaryContainer) {
            this.primaryContainer = primaryContainer;
            return this;
        }

        public final List<ContainerDefinition.Builder> getContainers() {
            List<ContainerDefinition.Builder> result = ContainerDefinitionListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<ContainerDefinition.BuilderImpl> containers) {
            this.containers = ContainerDefinitionListCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<ContainerDefinition> containers) {
            this.containers = ContainerDefinitionListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(ContainerDefinition... containers) {
            containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<ContainerDefinition.Builder>... containers) {
            containers(Stream.of(containers).map(c -> ContainerDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final InferenceExecutionConfig.Builder getInferenceExecutionConfig() {
            return inferenceExecutionConfig != null ? inferenceExecutionConfig.toBuilder() : null;
        }

        public final void setInferenceExecutionConfig(InferenceExecutionConfig.BuilderImpl inferenceExecutionConfig) {
            this.inferenceExecutionConfig = inferenceExecutionConfig != null ? inferenceExecutionConfig.build() : null;
        }

        @Override
        public final Builder inferenceExecutionConfig(InferenceExecutionConfig inferenceExecutionConfig) {
            this.inferenceExecutionConfig = inferenceExecutionConfig;
            return this;
        }

        public final String getExecutionRoleArn() {
            return executionRoleArn;
        }

        public final void setExecutionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
        }

        @Override
        public final Builder executionRoleArn(String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Boolean getEnableNetworkIsolation() {
            return enableNetworkIsolation;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DeploymentRecommendation.Builder getDeploymentRecommendation() {
            return deploymentRecommendation != null ? deploymentRecommendation.toBuilder() : null;
        }

        public final void setDeploymentRecommendation(DeploymentRecommendation.BuilderImpl deploymentRecommendation) {
            this.deploymentRecommendation = deploymentRecommendation != null ? deploymentRecommendation.build() : null;
        }

        @Override
        public final Builder deploymentRecommendation(DeploymentRecommendation deploymentRecommendation) {
            this.deploymentRecommendation = deploymentRecommendation;
            return this;
        }

        @Override
        public Model build() {
            return new Model(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
