/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains a list of recommendation jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceRecommendationsJob implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceRecommendationsJob.Builder, InferenceRecommendationsJob> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(InferenceRecommendationsJob::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobDescription").getter(getter(InferenceRecommendationsJob::jobDescription))
            .setter(setter(Builder::jobDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDescription").build()).build();

    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobType").getter(getter(InferenceRecommendationsJob::jobTypeAsString)).setter(setter(Builder::jobType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobArn")
            .getter(getter(InferenceRecommendationsJob::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InferenceRecommendationsJob::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(InferenceRecommendationsJob::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompletionTime").getter(getter(InferenceRecommendationsJob::completionTime))
            .setter(setter(Builder::completionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionTime").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(InferenceRecommendationsJob::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(InferenceRecommendationsJob::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(InferenceRecommendationsJob::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(InferenceRecommendationsJob::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> SAMPLE_PAYLOAD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SamplePayloadUrl").getter(getter(InferenceRecommendationsJob::samplePayloadUrl))
            .setter(setter(Builder::samplePayloadUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplePayloadUrl").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageVersionArn").getter(getter(InferenceRecommendationsJob::modelPackageVersionArn))
            .setter(setter(Builder::modelPackageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_DESCRIPTION_FIELD, JOB_TYPE_FIELD, JOB_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, COMPLETION_TIME_FIELD,
            ROLE_ARN_FIELD, LAST_MODIFIED_TIME_FIELD, FAILURE_REASON_FIELD, MODEL_NAME_FIELD, SAMPLE_PAYLOAD_URL_FIELD,
            MODEL_PACKAGE_VERSION_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String jobDescription;

    private final String jobType;

    private final String jobArn;

    private final String status;

    private final Instant creationTime;

    private final Instant completionTime;

    private final String roleArn;

    private final Instant lastModifiedTime;

    private final String failureReason;

    private final String modelName;

    private final String samplePayloadUrl;

    private final String modelPackageVersionArn;

    private InferenceRecommendationsJob(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobDescription = builder.jobDescription;
        this.jobType = builder.jobType;
        this.jobArn = builder.jobArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.completionTime = builder.completionTime;
        this.roleArn = builder.roleArn;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.failureReason = builder.failureReason;
        this.modelName = builder.modelName;
        this.samplePayloadUrl = builder.samplePayloadUrl;
        this.modelPackageVersionArn = builder.modelPackageVersionArn;
    }

    /**
     * <p>
     * The name of the job.
     * </p>
     * 
     * @return The name of the job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * The job description.
     * </p>
     * 
     * @return The job description.
     */
    public final String jobDescription() {
        return jobDescription;
    }

    /**
     * <p>
     * The recommendation job type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link RecommendationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The recommendation job type.
     * @see RecommendationJobType
     */
    public final RecommendationJobType jobType() {
        return RecommendationJobType.fromValue(jobType);
    }

    /**
     * <p>
     * The recommendation job type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobType} will
     * return {@link RecommendationJobType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #jobTypeAsString}.
     * </p>
     * 
     * @return The recommendation job type.
     * @see RecommendationJobType
     */
    public final String jobTypeAsString() {
        return jobType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the recommendation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the recommendation job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see RecommendationJobStatus
     */
    public final RecommendationJobStatus status() {
        return RecommendationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the job.
     * @see RecommendationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A timestamp that shows when the job was created.
     * </p>
     * 
     * @return A timestamp that shows when the job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A timestamp that shows when the job completed.
     * </p>
     * 
     * @return A timestamp that shows when the job completed.
     */
    public final Instant completionTime() {
        return completionTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your
     *         behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A timestamp that shows when the job was last modified.
     * </p>
     * 
     * @return A timestamp that shows when the job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * If the job fails, provides information why the job failed.
     * </p>
     * 
     * @return If the job fails, provides information why the job failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The name of the created model.
     * </p>
     * 
     * @return The name of the created model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must point to a
     * single gzip compressed tar archive (.tar.gz suffix).
     * </p>
     * 
     * @return The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must
     *         point to a single gzip compressed tar archive (.tar.gz suffix).
     */
    public final String samplePayloadUrl() {
        return samplePayloadUrl;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a versioned model package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a versioned model package.
     */
    public final String modelPackageVersionArn() {
        return modelPackageVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(samplePayloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageVersionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceRecommendationsJob)) {
            return false;
        }
        InferenceRecommendationsJob other = (InferenceRecommendationsJob) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobDescription(), other.jobDescription())
                && Objects.equals(jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(completionTime(), other.completionTime()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(modelName(), other.modelName())
                && Objects.equals(samplePayloadUrl(), other.samplePayloadUrl())
                && Objects.equals(modelPackageVersionArn(), other.modelPackageVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceRecommendationsJob").add("JobName", jobName()).add("JobDescription", jobDescription())
                .add("JobType", jobTypeAsString()).add("JobArn", jobArn()).add("Status", statusAsString())
                .add("CreationTime", creationTime()).add("CompletionTime", completionTime()).add("RoleArn", roleArn())
                .add("LastModifiedTime", lastModifiedTime()).add("FailureReason", failureReason()).add("ModelName", modelName())
                .add("SamplePayloadUrl", samplePayloadUrl()).add("ModelPackageVersionArn", modelPackageVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobDescription":
            return Optional.ofNullable(clazz.cast(jobDescription()));
        case "JobType":
            return Optional.ofNullable(clazz.cast(jobTypeAsString()));
        case "JobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompletionTime":
            return Optional.ofNullable(clazz.cast(completionTime()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "SamplePayloadUrl":
            return Optional.ofNullable(clazz.cast(samplePayloadUrl()));
        case "ModelPackageVersionArn":
            return Optional.ofNullable(clazz.cast(modelPackageVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceRecommendationsJob, T> g) {
        return obj -> g.apply((InferenceRecommendationsJob) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceRecommendationsJob> {
        /**
         * <p>
         * The name of the job.
         * </p>
         * 
         * @param jobName
         *        The name of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * The job description.
         * </p>
         * 
         * @param jobDescription
         *        The job description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDescription(String jobDescription);

        /**
         * <p>
         * The recommendation job type.
         * </p>
         * 
         * @param jobType
         *        The recommendation job type.
         * @see RecommendationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobType
         */
        Builder jobType(String jobType);

        /**
         * <p>
         * The recommendation job type.
         * </p>
         * 
         * @param jobType
         *        The recommendation job type.
         * @see RecommendationJobType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobType
         */
        Builder jobType(RecommendationJobType jobType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the recommendation job.
         * </p>
         * 
         * @param jobArn
         *        The Amazon Resource Name (ARN) of the recommendation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param status
         *        The status of the job.
         * @see RecommendationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the job.
         * </p>
         * 
         * @param status
         *        The status of the job.
         * @see RecommendationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationJobStatus
         */
        Builder status(RecommendationJobStatus status);

        /**
         * <p>
         * A timestamp that shows when the job was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that shows when the job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A timestamp that shows when the job completed.
         * </p>
         * 
         * @param completionTime
         *        A timestamp that shows when the job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completionTime(Instant completionTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker to perform tasks on your
         *        behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A timestamp that shows when the job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        A timestamp that shows when the job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * If the job fails, provides information why the job failed.
         * </p>
         * 
         * @param failureReason
         *        If the job fails, provides information why the job failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The name of the created model.
         * </p>
         * 
         * @param modelName
         *        The name of the created model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must point
         * to a single gzip compressed tar archive (.tar.gz suffix).
         * </p>
         * 
         * @param samplePayloadUrl
         *        The Amazon Simple Storage Service (Amazon S3) path where the sample payload is stored. This path must
         *        point to a single gzip compressed tar archive (.tar.gz suffix).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplePayloadUrl(String samplePayloadUrl);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a versioned model package.
         * </p>
         * 
         * @param modelPackageVersionArn
         *        The Amazon Resource Name (ARN) of a versioned model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageVersionArn(String modelPackageVersionArn);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String jobDescription;

        private String jobType;

        private String jobArn;

        private String status;

        private Instant creationTime;

        private Instant completionTime;

        private String roleArn;

        private Instant lastModifiedTime;

        private String failureReason;

        private String modelName;

        private String samplePayloadUrl;

        private String modelPackageVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceRecommendationsJob model) {
            jobName(model.jobName);
            jobDescription(model.jobDescription);
            jobType(model.jobType);
            jobArn(model.jobArn);
            status(model.status);
            creationTime(model.creationTime);
            completionTime(model.completionTime);
            roleArn(model.roleArn);
            lastModifiedTime(model.lastModifiedTime);
            failureReason(model.failureReason);
            modelName(model.modelName);
            samplePayloadUrl(model.samplePayloadUrl);
            modelPackageVersionArn(model.modelPackageVersionArn);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobDescription() {
            return jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final String getJobType() {
            return jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(RecommendationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompletionTime() {
            return completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getSamplePayloadUrl() {
            return samplePayloadUrl;
        }

        public final void setSamplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
        }

        @Override
        public final Builder samplePayloadUrl(String samplePayloadUrl) {
            this.samplePayloadUrl = samplePayloadUrl;
            return this;
        }

        public final String getModelPackageVersionArn() {
            return modelPackageVersionArn;
        }

        public final void setModelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
        }

        @Override
        public final Builder modelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
            return this;
        }

        @Override
        public InferenceRecommendationsJob build() {
            return new InferenceRecommendationsJob(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
