/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLineageGroupPolicyResponse extends SageMakerResponse implements
        ToCopyableBuilder<GetLineageGroupPolicyResponse.Builder, GetLineageGroupPolicyResponse> {
    private static final SdkField<String> LINEAGE_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LineageGroupArn").getter(getter(GetLineageGroupPolicyResponse::lineageGroupArn))
            .setter(setter(Builder::lineageGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageGroupArn").build()).build();

    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePolicy").getter(getter(GetLineageGroupPolicyResponse::resourcePolicy))
            .setter(setter(Builder::resourcePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINEAGE_GROUP_ARN_FIELD,
            RESOURCE_POLICY_FIELD));

    private final String lineageGroupArn;

    private final String resourcePolicy;

    private GetLineageGroupPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.lineageGroupArn = builder.lineageGroupArn;
        this.resourcePolicy = builder.resourcePolicy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the lineage group.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the lineage group.
     */
    public final String lineageGroupArn() {
        return lineageGroupArn;
    }

    /**
     * <p>
     * The resource policy that gives access to the lineage group in another account.
     * </p>
     * 
     * @return The resource policy that gives access to the lineage group in another account.
     */
    public final String resourcePolicy() {
        return resourcePolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lineageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLineageGroupPolicyResponse)) {
            return false;
        }
        GetLineageGroupPolicyResponse other = (GetLineageGroupPolicyResponse) obj;
        return Objects.equals(lineageGroupArn(), other.lineageGroupArn())
                && Objects.equals(resourcePolicy(), other.resourcePolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLineageGroupPolicyResponse").add("LineageGroupArn", lineageGroupArn())
                .add("ResourcePolicy", resourcePolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LineageGroupArn":
            return Optional.ofNullable(clazz.cast(lineageGroupArn()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLineageGroupPolicyResponse, T> g) {
        return obj -> g.apply((GetLineageGroupPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLineageGroupPolicyResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the lineage group.
         * </p>
         * 
         * @param lineageGroupArn
         *        The Amazon Resource Name (ARN) of the lineage group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lineageGroupArn(String lineageGroupArn);

        /**
         * <p>
         * The resource policy that gives access to the lineage group in another account.
         * </p>
         * 
         * @param resourcePolicy
         *        The resource policy that gives access to the lineage group in another account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String lineageGroupArn;

        private String resourcePolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLineageGroupPolicyResponse model) {
            super(model);
            lineageGroupArn(model.lineageGroupArn);
            resourcePolicy(model.resourcePolicy);
        }

        public final String getLineageGroupArn() {
            return lineageGroupArn;
        }

        public final void setLineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
        }

        @Override
        public final Builder lineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
            return this;
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        @Override
        public GetLineageGroupPolicyResponse build() {
            return new GetLineageGroupPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
