/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppImageConfigResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeAppImageConfigResponse.Builder, DescribeAppImageConfigResponse> {
    private static final SdkField<String> APP_IMAGE_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppImageConfigArn").getter(getter(DescribeAppImageConfigResponse::appImageConfigArn))
            .setter(setter(Builder::appImageConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigArn").build()).build();

    private static final SdkField<String> APP_IMAGE_CONFIG_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppImageConfigName").getter(getter(DescribeAppImageConfigResponse::appImageConfigName))
            .setter(setter(Builder::appImageConfigName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigName").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeAppImageConfigResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeAppImageConfigResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<KernelGatewayImageConfig> KERNEL_GATEWAY_IMAGE_CONFIG_FIELD = SdkField
            .<KernelGatewayImageConfig> builder(MarshallingType.SDK_POJO).memberName("KernelGatewayImageConfig")
            .getter(getter(DescribeAppImageConfigResponse::kernelGatewayImageConfig))
            .setter(setter(Builder::kernelGatewayImageConfig)).constructor(KernelGatewayImageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayImageConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_IMAGE_CONFIG_ARN_FIELD,
            APP_IMAGE_CONFIG_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, KERNEL_GATEWAY_IMAGE_CONFIG_FIELD));

    private final String appImageConfigArn;

    private final String appImageConfigName;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final KernelGatewayImageConfig kernelGatewayImageConfig;

    private DescribeAppImageConfigResponse(BuilderImpl builder) {
        super(builder);
        this.appImageConfigArn = builder.appImageConfigArn;
        this.appImageConfigName = builder.appImageConfigName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.kernelGatewayImageConfig = builder.kernelGatewayImageConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AppImageConfig.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AppImageConfig.
     */
    public final String appImageConfigArn() {
        return appImageConfigArn;
    }

    /**
     * <p>
     * The name of the AppImageConfig.
     * </p>
     * 
     * @return The name of the AppImageConfig.
     */
    public final String appImageConfigName() {
        return appImageConfigName;
    }

    /**
     * <p>
     * When the AppImageConfig was created.
     * </p>
     * 
     * @return When the AppImageConfig was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the AppImageConfig was last modified.
     * </p>
     * 
     * @return When the AppImageConfig was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The configuration of a KernelGateway app.
     * </p>
     * 
     * @return The configuration of a KernelGateway app.
     */
    public final KernelGatewayImageConfig kernelGatewayImageConfig() {
        return kernelGatewayImageConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appImageConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(appImageConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(kernelGatewayImageConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppImageConfigResponse)) {
            return false;
        }
        DescribeAppImageConfigResponse other = (DescribeAppImageConfigResponse) obj;
        return Objects.equals(appImageConfigArn(), other.appImageConfigArn())
                && Objects.equals(appImageConfigName(), other.appImageConfigName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(kernelGatewayImageConfig(), other.kernelGatewayImageConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAppImageConfigResponse").add("AppImageConfigArn", appImageConfigArn())
                .add("AppImageConfigName", appImageConfigName()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("KernelGatewayImageConfig", kernelGatewayImageConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppImageConfigArn":
            return Optional.ofNullable(clazz.cast(appImageConfigArn()));
        case "AppImageConfigName":
            return Optional.ofNullable(clazz.cast(appImageConfigName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "KernelGatewayImageConfig":
            return Optional.ofNullable(clazz.cast(kernelGatewayImageConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppImageConfigResponse, T> g) {
        return obj -> g.apply((DescribeAppImageConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAppImageConfigResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AppImageConfig.
         * </p>
         * 
         * @param appImageConfigArn
         *        The Amazon Resource Name (ARN) of the AppImageConfig.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appImageConfigArn(String appImageConfigArn);

        /**
         * <p>
         * The name of the AppImageConfig.
         * </p>
         * 
         * @param appImageConfigName
         *        The name of the AppImageConfig.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appImageConfigName(String appImageConfigName);

        /**
         * <p>
         * When the AppImageConfig was created.
         * </p>
         * 
         * @param creationTime
         *        When the AppImageConfig was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the AppImageConfig was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        When the AppImageConfig was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The configuration of a KernelGateway app.
         * </p>
         * 
         * @param kernelGatewayImageConfig
         *        The configuration of a KernelGateway app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelGatewayImageConfig(KernelGatewayImageConfig kernelGatewayImageConfig);

        /**
         * <p>
         * The configuration of a KernelGateway app.
         * </p>
         * This is a convenience method that creates an instance of the {@link KernelGatewayImageConfig.Builder}
         * avoiding the need to create one manually via {@link KernelGatewayImageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KernelGatewayImageConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #kernelGatewayImageConfig(KernelGatewayImageConfig)}.
         * 
         * @param kernelGatewayImageConfig
         *        a consumer that will call methods on {@link KernelGatewayImageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kernelGatewayImageConfig(KernelGatewayImageConfig)
         */
        default Builder kernelGatewayImageConfig(Consumer<KernelGatewayImageConfig.Builder> kernelGatewayImageConfig) {
            return kernelGatewayImageConfig(KernelGatewayImageConfig.builder().applyMutation(kernelGatewayImageConfig).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String appImageConfigArn;

        private String appImageConfigName;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private KernelGatewayImageConfig kernelGatewayImageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppImageConfigResponse model) {
            super(model);
            appImageConfigArn(model.appImageConfigArn);
            appImageConfigName(model.appImageConfigName);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            kernelGatewayImageConfig(model.kernelGatewayImageConfig);
        }

        public final String getAppImageConfigArn() {
            return appImageConfigArn;
        }

        public final void setAppImageConfigArn(String appImageConfigArn) {
            this.appImageConfigArn = appImageConfigArn;
        }

        @Override
        public final Builder appImageConfigArn(String appImageConfigArn) {
            this.appImageConfigArn = appImageConfigArn;
            return this;
        }

        public final String getAppImageConfigName() {
            return appImageConfigName;
        }

        public final void setAppImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
        }

        @Override
        public final Builder appImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final KernelGatewayImageConfig.Builder getKernelGatewayImageConfig() {
            return kernelGatewayImageConfig != null ? kernelGatewayImageConfig.toBuilder() : null;
        }

        public final void setKernelGatewayImageConfig(KernelGatewayImageConfig.BuilderImpl kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig != null ? kernelGatewayImageConfig.build() : null;
        }

        @Override
        public final Builder kernelGatewayImageConfig(KernelGatewayImageConfig kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig;
            return this;
        }

        @Override
        public DescribeAppImageConfigResponse build() {
            return new DescribeAppImageConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
