/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides summary information about the model package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDescribeModelPackageSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDescribeModelPackageSummary.Builder, BatchDescribeModelPackageSummary> {
    private static final SdkField<String> MODEL_PACKAGE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageGroupName").getter(getter(BatchDescribeModelPackageSummary::modelPackageGroupName))
            .setter(setter(Builder::modelPackageGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageGroupName").build())
            .build();

    private static final SdkField<Integer> MODEL_PACKAGE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelPackageVersion").getter(getter(BatchDescribeModelPackageSummary::modelPackageVersion))
            .setter(setter(Builder::modelPackageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersion").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageArn").getter(getter(BatchDescribeModelPackageSummary::modelPackageArn))
            .setter(setter(Builder::modelPackageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageArn").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageDescription").getter(getter(BatchDescribeModelPackageSummary::modelPackageDescription))
            .setter(setter(Builder::modelPackageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(BatchDescribeModelPackageSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<InferenceSpecification> INFERENCE_SPECIFICATION_FIELD = SdkField
            .<InferenceSpecification> builder(MarshallingType.SDK_POJO).memberName("InferenceSpecification")
            .getter(getter(BatchDescribeModelPackageSummary::inferenceSpecification))
            .setter(setter(Builder::inferenceSpecification)).constructor(InferenceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSpecification").build())
            .build();

    private static final SdkField<String> MODEL_PACKAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageStatus").getter(getter(BatchDescribeModelPackageSummary::modelPackageStatusAsString))
            .setter(setter(Builder::modelPackageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageStatus").build())
            .build();

    private static final SdkField<String> MODEL_APPROVAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelApprovalStatus").getter(getter(BatchDescribeModelPackageSummary::modelApprovalStatusAsString))
            .setter(setter(Builder::modelApprovalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelApprovalStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_PACKAGE_GROUP_NAME_FIELD, MODEL_PACKAGE_VERSION_FIELD, MODEL_PACKAGE_ARN_FIELD,
            MODEL_PACKAGE_DESCRIPTION_FIELD, CREATION_TIME_FIELD, INFERENCE_SPECIFICATION_FIELD, MODEL_PACKAGE_STATUS_FIELD,
            MODEL_APPROVAL_STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String modelPackageGroupName;

    private final Integer modelPackageVersion;

    private final String modelPackageArn;

    private final String modelPackageDescription;

    private final Instant creationTime;

    private final InferenceSpecification inferenceSpecification;

    private final String modelPackageStatus;

    private final String modelApprovalStatus;

    private BatchDescribeModelPackageSummary(BuilderImpl builder) {
        this.modelPackageGroupName = builder.modelPackageGroupName;
        this.modelPackageVersion = builder.modelPackageVersion;
        this.modelPackageArn = builder.modelPackageArn;
        this.modelPackageDescription = builder.modelPackageDescription;
        this.creationTime = builder.creationTime;
        this.inferenceSpecification = builder.inferenceSpecification;
        this.modelPackageStatus = builder.modelPackageStatus;
        this.modelApprovalStatus = builder.modelApprovalStatus;
    }

    /**
     * <p>
     * The group name for the model package
     * </p>
     * 
     * @return The group name for the model package
     */
    public final String modelPackageGroupName() {
        return modelPackageGroupName;
    }

    /**
     * <p>
     * The version number of a versioned model.
     * </p>
     * 
     * @return The version number of a versioned model.
     */
    public final Integer modelPackageVersion() {
        return modelPackageVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model package.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model package.
     */
    public final String modelPackageArn() {
        return modelPackageArn;
    }

    /**
     * <p>
     * The description of the model package.
     * </p>
     * 
     * @return The description of the model package.
     */
    public final String modelPackageDescription() {
        return modelPackageDescription;
    }

    /**
     * <p>
     * The creation time of the mortgage package summary.
     * </p>
     * 
     * @return The creation time of the mortgage package summary.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the InferenceSpecification property for this object.
     * 
     * @return The value of the InferenceSpecification property for this object.
     */
    public final InferenceSpecification inferenceSpecification() {
        return inferenceSpecification;
    }

    /**
     * <p>
     * The status of the mortgage package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The status of the mortgage package.
     * @see ModelPackageStatus
     */
    public final ModelPackageStatus modelPackageStatus() {
        return ModelPackageStatus.fromValue(modelPackageStatus);
    }

    /**
     * <p>
     * The status of the mortgage package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelPackageStatus} will return {@link ModelPackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #modelPackageStatusAsString}.
     * </p>
     * 
     * @return The status of the mortgage package.
     * @see ModelPackageStatus
     */
    public final String modelPackageStatusAsString() {
        return modelPackageStatus;
    }

    /**
     * <p>
     * The approval status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model.
     * @see ModelApprovalStatus
     */
    public final ModelApprovalStatus modelApprovalStatus() {
        return ModelApprovalStatus.fromValue(modelApprovalStatus);
    }

    /**
     * <p>
     * The approval status of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelApprovalStatus} will return {@link ModelApprovalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #modelApprovalStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model.
     * @see ModelApprovalStatus
     */
    public final String modelApprovalStatusAsString() {
        return modelApprovalStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelApprovalStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDescribeModelPackageSummary)) {
            return false;
        }
        BatchDescribeModelPackageSummary other = (BatchDescribeModelPackageSummary) obj;
        return Objects.equals(modelPackageGroupName(), other.modelPackageGroupName())
                && Objects.equals(modelPackageVersion(), other.modelPackageVersion())
                && Objects.equals(modelPackageArn(), other.modelPackageArn())
                && Objects.equals(modelPackageDescription(), other.modelPackageDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(inferenceSpecification(), other.inferenceSpecification())
                && Objects.equals(modelPackageStatusAsString(), other.modelPackageStatusAsString())
                && Objects.equals(modelApprovalStatusAsString(), other.modelApprovalStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDescribeModelPackageSummary").add("ModelPackageGroupName", modelPackageGroupName())
                .add("ModelPackageVersion", modelPackageVersion()).add("ModelPackageArn", modelPackageArn())
                .add("ModelPackageDescription", modelPackageDescription()).add("CreationTime", creationTime())
                .add("InferenceSpecification", inferenceSpecification()).add("ModelPackageStatus", modelPackageStatusAsString())
                .add("ModelApprovalStatus", modelApprovalStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelPackageGroupName":
            return Optional.ofNullable(clazz.cast(modelPackageGroupName()));
        case "ModelPackageVersion":
            return Optional.ofNullable(clazz.cast(modelPackageVersion()));
        case "ModelPackageArn":
            return Optional.ofNullable(clazz.cast(modelPackageArn()));
        case "ModelPackageDescription":
            return Optional.ofNullable(clazz.cast(modelPackageDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "InferenceSpecification":
            return Optional.ofNullable(clazz.cast(inferenceSpecification()));
        case "ModelPackageStatus":
            return Optional.ofNullable(clazz.cast(modelPackageStatusAsString()));
        case "ModelApprovalStatus":
            return Optional.ofNullable(clazz.cast(modelApprovalStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDescribeModelPackageSummary, T> g) {
        return obj -> g.apply((BatchDescribeModelPackageSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDescribeModelPackageSummary> {
        /**
         * <p>
         * The group name for the model package
         * </p>
         * 
         * @param modelPackageGroupName
         *        The group name for the model package
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageGroupName(String modelPackageGroupName);

        /**
         * <p>
         * The version number of a versioned model.
         * </p>
         * 
         * @param modelPackageVersion
         *        The version number of a versioned model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageVersion(Integer modelPackageVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model package.
         * </p>
         * 
         * @param modelPackageArn
         *        The Amazon Resource Name (ARN) of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageArn(String modelPackageArn);

        /**
         * <p>
         * The description of the model package.
         * </p>
         * 
         * @param modelPackageDescription
         *        The description of the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageDescription(String modelPackageDescription);

        /**
         * <p>
         * The creation time of the mortgage package summary.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the mortgage package summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the InferenceSpecification property for this object.
         *
         * @param inferenceSpecification
         *        The new value for the InferenceSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSpecification(InferenceSpecification inferenceSpecification);

        /**
         * Sets the value of the InferenceSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InferenceSpecification.Builder} avoiding
         * the need to create one manually via {@link InferenceSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceSpecification(InferenceSpecification)}.
         * 
         * @param inferenceSpecification
         *        a consumer that will call methods on {@link InferenceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceSpecification(InferenceSpecification)
         */
        default Builder inferenceSpecification(Consumer<InferenceSpecification.Builder> inferenceSpecification) {
            return inferenceSpecification(InferenceSpecification.builder().applyMutation(inferenceSpecification).build());
        }

        /**
         * <p>
         * The status of the mortgage package.
         * </p>
         * 
         * @param modelPackageStatus
         *        The status of the mortgage package.
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(String modelPackageStatus);

        /**
         * <p>
         * The status of the mortgage package.
         * </p>
         * 
         * @param modelPackageStatus
         *        The status of the mortgage package.
         * @see ModelPackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelPackageStatus
         */
        Builder modelPackageStatus(ModelPackageStatus modelPackageStatus);

        /**
         * <p>
         * The approval status of the model.
         * </p>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model.
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(String modelApprovalStatus);

        /**
         * <p>
         * The approval status of the model.
         * </p>
         * 
         * @param modelApprovalStatus
         *        The approval status of the model.
         * @see ModelApprovalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelApprovalStatus
         */
        Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus);
    }

    static final class BuilderImpl implements Builder {
        private String modelPackageGroupName;

        private Integer modelPackageVersion;

        private String modelPackageArn;

        private String modelPackageDescription;

        private Instant creationTime;

        private InferenceSpecification inferenceSpecification;

        private String modelPackageStatus;

        private String modelApprovalStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDescribeModelPackageSummary model) {
            modelPackageGroupName(model.modelPackageGroupName);
            modelPackageVersion(model.modelPackageVersion);
            modelPackageArn(model.modelPackageArn);
            modelPackageDescription(model.modelPackageDescription);
            creationTime(model.creationTime);
            inferenceSpecification(model.inferenceSpecification);
            modelPackageStatus(model.modelPackageStatus);
            modelApprovalStatus(model.modelApprovalStatus);
        }

        public final String getModelPackageGroupName() {
            return modelPackageGroupName;
        }

        public final void setModelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
        }

        @Override
        public final Builder modelPackageGroupName(String modelPackageGroupName) {
            this.modelPackageGroupName = modelPackageGroupName;
            return this;
        }

        public final Integer getModelPackageVersion() {
            return modelPackageVersion;
        }

        public final void setModelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
        }

        @Override
        public final Builder modelPackageVersion(Integer modelPackageVersion) {
            this.modelPackageVersion = modelPackageVersion;
            return this;
        }

        public final String getModelPackageArn() {
            return modelPackageArn;
        }

        public final void setModelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
        }

        @Override
        public final Builder modelPackageArn(String modelPackageArn) {
            this.modelPackageArn = modelPackageArn;
            return this;
        }

        public final String getModelPackageDescription() {
            return modelPackageDescription;
        }

        public final void setModelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
        }

        @Override
        public final Builder modelPackageDescription(String modelPackageDescription) {
            this.modelPackageDescription = modelPackageDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final InferenceSpecification.Builder getInferenceSpecification() {
            return inferenceSpecification != null ? inferenceSpecification.toBuilder() : null;
        }

        public final void setInferenceSpecification(InferenceSpecification.BuilderImpl inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification != null ? inferenceSpecification.build() : null;
        }

        @Override
        public final Builder inferenceSpecification(InferenceSpecification inferenceSpecification) {
            this.inferenceSpecification = inferenceSpecification;
            return this;
        }

        public final String getModelPackageStatus() {
            return modelPackageStatus;
        }

        public final void setModelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
        }

        @Override
        public final Builder modelPackageStatus(String modelPackageStatus) {
            this.modelPackageStatus = modelPackageStatus;
            return this;
        }

        @Override
        public final Builder modelPackageStatus(ModelPackageStatus modelPackageStatus) {
            this.modelPackageStatus(modelPackageStatus == null ? null : modelPackageStatus.toString());
            return this;
        }

        public final String getModelApprovalStatus() {
            return modelApprovalStatus;
        }

        public final void setModelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
        }

        @Override
        public final Builder modelApprovalStatus(String modelApprovalStatus) {
            this.modelApprovalStatus = modelApprovalStatus;
            return this;
        }

        @Override
        public final Builder modelApprovalStatus(ModelApprovalStatus modelApprovalStatus) {
            this.modelApprovalStatus(modelApprovalStatus == null ? null : modelApprovalStatus.toString());
            return this;
        }

        @Override
        public BatchDescribeModelPackageSummary build() {
            return new BatchDescribeModelPackageSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
