/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListAliasesResponse;

public class ListAliasesIterable
implements SdkIterable<ListAliasesResponse> {
    private final SageMakerClient client;
    private final ListAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAliasesIterable(SageMakerClient client, ListAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAliasesResponseFetcher();
    }

    public Iterator<ListAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> sageMakerImageVersionAliases() {
        Function<ListAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.sageMakerImageVersionAliases() != null) {
                return response.sageMakerImageVersionAliases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAliasesResponseFetcher
    implements SyncPageFetcher<ListAliasesResponse> {
        private ListAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAliasesResponse nextPage(ListAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListAliasesIterable.this.client.listAliases(ListAliasesIterable.this.firstRequest);
            }
            return ListAliasesIterable.this.client.listAliases((ListAliasesRequest)((Object)ListAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

