/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelRegisterSettings;
import software.amazon.awssdk.services.sagemaker.model.TimeSeriesForecastingSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CanvasAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CanvasAppSettings> {
    private static final SdkField<TimeSeriesForecastingSettings> TIME_SERIES_FORECASTING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeSeriesForecastingSettings").getter(CanvasAppSettings.getter(CanvasAppSettings::timeSeriesForecastingSettings)).setter(CanvasAppSettings.setter(Builder::timeSeriesForecastingSettings)).constructor(TimeSeriesForecastingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesForecastingSettings").build()}).build();
    private static final SdkField<ModelRegisterSettings> MODEL_REGISTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelRegisterSettings").getter(CanvasAppSettings.getter(CanvasAppSettings::modelRegisterSettings)).setter(CanvasAppSettings.setter(Builder::modelRegisterSettings)).constructor(ModelRegisterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelRegisterSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_SERIES_FORECASTING_SETTINGS_FIELD, MODEL_REGISTER_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final TimeSeriesForecastingSettings timeSeriesForecastingSettings;
    private final ModelRegisterSettings modelRegisterSettings;

    private CanvasAppSettings(BuilderImpl builder) {
        this.timeSeriesForecastingSettings = builder.timeSeriesForecastingSettings;
        this.modelRegisterSettings = builder.modelRegisterSettings;
    }

    public final TimeSeriesForecastingSettings timeSeriesForecastingSettings() {
        return this.timeSeriesForecastingSettings;
    }

    public final ModelRegisterSettings modelRegisterSettings() {
        return this.modelRegisterSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeSeriesForecastingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelRegisterSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanvasAppSettings)) {
            return false;
        }
        CanvasAppSettings other = (CanvasAppSettings)obj;
        return Objects.equals(this.timeSeriesForecastingSettings(), other.timeSeriesForecastingSettings()) && Objects.equals(this.modelRegisterSettings(), other.modelRegisterSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CanvasAppSettings").add("TimeSeriesForecastingSettings", (Object)this.timeSeriesForecastingSettings()).add("ModelRegisterSettings", (Object)this.modelRegisterSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimeSeriesForecastingSettings": {
                return Optional.ofNullable(clazz.cast(this.timeSeriesForecastingSettings()));
            }
            case "ModelRegisterSettings": {
                return Optional.ofNullable(clazz.cast(this.modelRegisterSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CanvasAppSettings, T> g) {
        return obj -> g.apply((CanvasAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TimeSeriesForecastingSettings timeSeriesForecastingSettings;
        private ModelRegisterSettings modelRegisterSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CanvasAppSettings model) {
            this.timeSeriesForecastingSettings(model.timeSeriesForecastingSettings);
            this.modelRegisterSettings(model.modelRegisterSettings);
        }

        public final TimeSeriesForecastingSettings.Builder getTimeSeriesForecastingSettings() {
            return this.timeSeriesForecastingSettings != null ? this.timeSeriesForecastingSettings.toBuilder() : null;
        }

        public final void setTimeSeriesForecastingSettings(TimeSeriesForecastingSettings.BuilderImpl timeSeriesForecastingSettings) {
            this.timeSeriesForecastingSettings = timeSeriesForecastingSettings != null ? timeSeriesForecastingSettings.build() : null;
        }

        @Override
        public final Builder timeSeriesForecastingSettings(TimeSeriesForecastingSettings timeSeriesForecastingSettings) {
            this.timeSeriesForecastingSettings = timeSeriesForecastingSettings;
            return this;
        }

        public final ModelRegisterSettings.Builder getModelRegisterSettings() {
            return this.modelRegisterSettings != null ? this.modelRegisterSettings.toBuilder() : null;
        }

        public final void setModelRegisterSettings(ModelRegisterSettings.BuilderImpl modelRegisterSettings) {
            this.modelRegisterSettings = modelRegisterSettings != null ? modelRegisterSettings.build() : null;
        }

        @Override
        public final Builder modelRegisterSettings(ModelRegisterSettings modelRegisterSettings) {
            this.modelRegisterSettings = modelRegisterSettings;
            return this;
        }

        public CanvasAppSettings build() {
            return new CanvasAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CanvasAppSettings> {
        public Builder timeSeriesForecastingSettings(TimeSeriesForecastingSettings var1);

        default public Builder timeSeriesForecastingSettings(Consumer<TimeSeriesForecastingSettings.Builder> timeSeriesForecastingSettings) {
            return this.timeSeriesForecastingSettings((TimeSeriesForecastingSettings)((TimeSeriesForecastingSettings.Builder)TimeSeriesForecastingSettings.builder().applyMutation(timeSeriesForecastingSettings)).build());
        }

        public Builder modelRegisterSettings(ModelRegisterSettings var1);

        default public Builder modelRegisterSettings(Consumer<ModelRegisterSettings.Builder> modelRegisterSettings) {
            return this.modelRegisterSettings((ModelRegisterSettings)((ModelRegisterSettings.Builder)ModelRegisterSettings.builder().applyMutation(modelRegisterSettings)).build());
        }
    }
}

