/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.InferenceExperimentSummary;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceExperimentsResponse;

public class ListInferenceExperimentsIterable
implements SdkIterable<ListInferenceExperimentsResponse> {
    private final SageMakerClient client;
    private final ListInferenceExperimentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInferenceExperimentsIterable(SageMakerClient client, ListInferenceExperimentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInferenceExperimentsResponseFetcher();
    }

    public Iterator<ListInferenceExperimentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InferenceExperimentSummary> inferenceExperiments() {
        Function<ListInferenceExperimentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inferenceExperiments() != null) {
                return response.inferenceExperiments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInferenceExperimentsResponseFetcher
    implements SyncPageFetcher<ListInferenceExperimentsResponse> {
        private ListInferenceExperimentsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceExperimentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInferenceExperimentsResponse nextPage(ListInferenceExperimentsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceExperimentsIterable.this.client.listInferenceExperiments(ListInferenceExperimentsIterable.this.firstRequest);
            }
            return ListInferenceExperimentsIterable.this.client.listInferenceExperiments((ListInferenceExperimentsRequest)((Object)ListInferenceExperimentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

