/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.DeviceDeploymentSummary;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStageDevicesResponse;

public class ListStageDevicesIterable
implements SdkIterable<ListStageDevicesResponse> {
    private final SageMakerClient client;
    private final ListStageDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStageDevicesIterable(SageMakerClient client, ListStageDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStageDevicesResponseFetcher();
    }

    public Iterator<ListStageDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeviceDeploymentSummary> deviceDeploymentSummaries() {
        Function<ListStageDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.deviceDeploymentSummaries() != null) {
                return response.deviceDeploymentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStageDevicesResponseFetcher
    implements SyncPageFetcher<ListStageDevicesResponse> {
        private ListStageDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListStageDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStageDevicesResponse nextPage(ListStageDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListStageDevicesIterable.this.client.listStageDevices(ListStageDevicesIterable.this.firstRequest);
            }
            return ListStageDevicesIterable.this.client.listStageDevices((ListStageDevicesRequest)((Object)ListStageDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

