/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sagemaker.DefaultSageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.DefaultSageMakerBaseClientBuilder;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClientBuilder;
import software.amazon.awssdk.services.sagemaker.SageMakerServiceClientConfiguration;
import software.amazon.awssdk.services.sagemaker.endpoints.SageMakerEndpointProvider;

@SdkInternalApi
final class DefaultSageMakerAsyncClientBuilder
extends DefaultSageMakerBaseClientBuilder<SageMakerAsyncClientBuilder, SageMakerAsyncClient>
implements SageMakerAsyncClientBuilder {
    DefaultSageMakerAsyncClientBuilder() {
    }

    @Override
    public DefaultSageMakerAsyncClientBuilder endpointProvider(SageMakerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SageMakerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSageMakerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        SageMakerServiceClientConfiguration serviceClientConfiguration = SageMakerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultSageMakerAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

