/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sagemaker.DefaultSageMakerBaseClientBuilder;
import software.amazon.awssdk.services.sagemaker.DefaultSageMakerClient;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.SageMakerClientBuilder;
import software.amazon.awssdk.services.sagemaker.SageMakerServiceClientConfiguration;
import software.amazon.awssdk.services.sagemaker.endpoints.SageMakerEndpointProvider;

@SdkInternalApi
final class DefaultSageMakerClientBuilder
extends DefaultSageMakerBaseClientBuilder<SageMakerClientBuilder, SageMakerClient>
implements SageMakerClientBuilder {
    DefaultSageMakerClientBuilder() {
    }

    @Override
    public DefaultSageMakerClientBuilder endpointProvider(SageMakerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SageMakerClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSageMakerClientBuilder.validateClientOptions(clientConfiguration);
        SageMakerServiceClientConfiguration serviceClientConfiguration = SageMakerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultSageMakerClient(serviceClientConfiguration, clientConfiguration);
    }
}

