/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.Direction;
import software.amazon.awssdk.services.sagemaker.model.QueryFilters;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageStartArnsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryLineageRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, QueryLineageRequest> {
    private static final SdkField<List<String>> START_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StartArns").getter(QueryLineageRequest.getter(QueryLineageRequest::startArns)).setter(QueryLineageRequest.setter(Builder::startArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(QueryLineageRequest.getter(QueryLineageRequest::directionAsString)).setter(QueryLineageRequest.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<Boolean> INCLUDE_EDGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeEdges").getter(QueryLineageRequest.getter(QueryLineageRequest::includeEdges)).setter(QueryLineageRequest.setter(Builder::includeEdges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeEdges").build()}).build();
    private static final SdkField<QueryFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(QueryLineageRequest.getter(QueryLineageRequest::filters)).setter(QueryLineageRequest.setter(Builder::filters)).constructor(QueryFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<Integer> MAX_DEPTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxDepth").getter(QueryLineageRequest.getter(QueryLineageRequest::maxDepth)).setter(QueryLineageRequest.setter(Builder::maxDepth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDepth").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(QueryLineageRequest.getter(QueryLineageRequest::maxResults)).setter(QueryLineageRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(QueryLineageRequest.getter(QueryLineageRequest::nextToken)).setter(QueryLineageRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_ARNS_FIELD, DIRECTION_FIELD, INCLUDE_EDGES_FIELD, FILTERS_FIELD, MAX_DEPTH_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> startArns;
    private final String direction;
    private final Boolean includeEdges;
    private final QueryFilters filters;
    private final Integer maxDepth;
    private final Integer maxResults;
    private final String nextToken;

    private QueryLineageRequest(BuilderImpl builder) {
        super(builder);
        this.startArns = builder.startArns;
        this.direction = builder.direction;
        this.includeEdges = builder.includeEdges;
        this.filters = builder.filters;
        this.maxDepth = builder.maxDepth;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStartArns() {
        return this.startArns != null && !(this.startArns instanceof SdkAutoConstructList);
    }

    public final List<String> startArns() {
        return this.startArns;
    }

    public final Direction direction() {
        return Direction.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public final Boolean includeEdges() {
        return this.includeEdges;
    }

    public final QueryFilters filters() {
        return this.filters;
    }

    public final Integer maxDepth() {
        return this.maxDepth;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStartArns() ? this.startArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeEdges());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDepth());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryLineageRequest)) {
            return false;
        }
        QueryLineageRequest other = (QueryLineageRequest)((Object)obj);
        return this.hasStartArns() == other.hasStartArns() && Objects.equals(this.startArns(), other.startArns()) && Objects.equals(this.directionAsString(), other.directionAsString()) && Objects.equals(this.includeEdges(), other.includeEdges()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxDepth(), other.maxDepth()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"QueryLineageRequest").add("StartArns", this.hasStartArns() ? this.startArns() : null).add("Direction", (Object)this.directionAsString()).add("IncludeEdges", (Object)this.includeEdges()).add("Filters", (Object)this.filters()).add("MaxDepth", (Object)this.maxDepth()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartArns": {
                return Optional.ofNullable(clazz.cast(this.startArns()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "IncludeEdges": {
                return Optional.ofNullable(clazz.cast(this.includeEdges()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "MaxDepth": {
                return Optional.ofNullable(clazz.cast(this.maxDepth()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryLineageRequest, T> g) {
        return obj -> g.apply((QueryLineageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private List<String> startArns = DefaultSdkAutoConstructList.getInstance();
        private String direction;
        private Boolean includeEdges;
        private QueryFilters filters;
        private Integer maxDepth;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryLineageRequest model) {
            super(model);
            this.startArns(model.startArns);
            this.direction(model.direction);
            this.includeEdges(model.includeEdges);
            this.filters(model.filters);
            this.maxDepth(model.maxDepth);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getStartArns() {
            if (this.startArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.startArns;
        }

        public final void setStartArns(Collection<String> startArns) {
            this.startArns = QueryLineageStartArnsCopier.copy(startArns);
        }

        @Override
        public final Builder startArns(Collection<String> startArns) {
            this.startArns = QueryLineageStartArnsCopier.copy(startArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder startArns(String ... startArns) {
            this.startArns(Arrays.asList(startArns));
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(Direction direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final Boolean getIncludeEdges() {
            return this.includeEdges;
        }

        public final void setIncludeEdges(Boolean includeEdges) {
            this.includeEdges = includeEdges;
        }

        @Override
        public final Builder includeEdges(Boolean includeEdges) {
            this.includeEdges = includeEdges;
            return this;
        }

        public final QueryFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(QueryFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(QueryFilters filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxDepth() {
            return this.maxDepth;
        }

        public final void setMaxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
        }

        @Override
        public final Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QueryLineageRequest build() {
            return new QueryLineageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, QueryLineageRequest> {
        public Builder startArns(Collection<String> var1);

        public Builder startArns(String ... var1);

        public Builder direction(String var1);

        public Builder direction(Direction var1);

        public Builder includeEdges(Boolean var1);

        public Builder filters(QueryFilters var1);

        default public Builder filters(Consumer<QueryFilters.Builder> filters) {
            return this.filters((QueryFilters)((QueryFilters.Builder)QueryFilters.builder().applyMutation(filters)).build());
        }

        public Builder maxDepth(Integer var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

