/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.DeviceSummary;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDevicesResponse;

public class ListDevicesIterable
implements SdkIterable<ListDevicesResponse> {
    private final SageMakerClient client;
    private final ListDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevicesIterable(SageMakerClient client, ListDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDevicesResponseFetcher();
    }

    public Iterator<ListDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeviceSummary> deviceSummaries() {
        Function<ListDevicesResponse, Iterator> getIterator = response -> {
            if (response != null && response.deviceSummaries() != null) {
                return response.deviceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDevicesResponseFetcher
    implements SyncPageFetcher<ListDevicesResponse> {
        private ListDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevicesResponse nextPage(ListDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListDevicesIterable.this.client.listDevices(ListDevicesIterable.this.firstRequest);
            }
            return ListDevicesIterable.this.client.listDevices((ListDevicesRequest)((Object)ListDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

