/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinition;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobDefinitionsCopier;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTrainingJobSummary;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobCompletionDetails;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConfig;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobConsumedResources;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobStatus;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobWarmStartConfig;
import software.amazon.awssdk.services.sagemaker.model.ObjectiveStatusCounters;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.TrainingJobStatusCounters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHyperParameterTuningJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeHyperParameterTuningJobResponse> {
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HyperParameterTuningJobName").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningJobName)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::hyperParameterTuningJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobName").build()}).build();
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HyperParameterTuningJobArn").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningJobArn)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::hyperParameterTuningJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobArn").build()}).build();
    private static final SdkField<HyperParameterTuningJobConfig> HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HyperParameterTuningJobConfig").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningJobConfig)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::hyperParameterTuningJobConfig)).constructor(HyperParameterTuningJobConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobConfig").build()}).build();
    private static final SdkField<HyperParameterTrainingJobDefinition> TRAINING_JOB_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingJobDefinition").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::trainingJobDefinition)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::trainingJobDefinition)).constructor(HyperParameterTrainingJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinition").build()}).build();
    private static final SdkField<List<HyperParameterTrainingJobDefinition>> TRAINING_JOB_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TrainingJobDefinitions").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::trainingJobDefinitions)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::trainingJobDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HyperParameterTrainingJobDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HYPER_PARAMETER_TUNING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HyperParameterTuningJobStatus").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningJobStatusAsString)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::hyperParameterTuningJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningJobStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::creationTime)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> HYPER_PARAMETER_TUNING_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("HyperParameterTuningEndTime").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::hyperParameterTuningEndTime)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::hyperParameterTuningEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterTuningEndTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::lastModifiedTime)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<TrainingJobStatusCounters> TRAINING_JOB_STATUS_COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrainingJobStatusCounters").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::trainingJobStatusCounters)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::trainingJobStatusCounters)).constructor(TrainingJobStatusCounters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobStatusCounters").build()}).build();
    private static final SdkField<ObjectiveStatusCounters> OBJECTIVE_STATUS_COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ObjectiveStatusCounters").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::objectiveStatusCounters)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::objectiveStatusCounters)).constructor(ObjectiveStatusCounters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectiveStatusCounters").build()}).build();
    private static final SdkField<HyperParameterTrainingJobSummary> BEST_TRAINING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BestTrainingJob").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::bestTrainingJob)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::bestTrainingJob)).constructor(HyperParameterTrainingJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BestTrainingJob").build()}).build();
    private static final SdkField<HyperParameterTrainingJobSummary> OVERALL_BEST_TRAINING_JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverallBestTrainingJob").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::overallBestTrainingJob)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::overallBestTrainingJob)).constructor(HyperParameterTrainingJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverallBestTrainingJob").build()}).build();
    private static final SdkField<HyperParameterTuningJobWarmStartConfig> WARM_START_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WarmStartConfig").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::warmStartConfig)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::warmStartConfig)).constructor(HyperParameterTuningJobWarmStartConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarmStartConfig").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::failureReason)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<HyperParameterTuningJobCompletionDetails> TUNING_JOB_COMPLETION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TuningJobCompletionDetails").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::tuningJobCompletionDetails)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::tuningJobCompletionDetails)).constructor(HyperParameterTuningJobCompletionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningJobCompletionDetails").build()}).build();
    private static final SdkField<HyperParameterTuningJobConsumedResources> CONSUMED_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConsumedResources").getter(DescribeHyperParameterTuningJobResponse.getter(DescribeHyperParameterTuningJobResponse::consumedResources)).setter(DescribeHyperParameterTuningJobResponse.setter(Builder::consumedResources)).constructor(HyperParameterTuningJobConsumedResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumedResources").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPER_PARAMETER_TUNING_JOB_NAME_FIELD, HYPER_PARAMETER_TUNING_JOB_ARN_FIELD, HYPER_PARAMETER_TUNING_JOB_CONFIG_FIELD, TRAINING_JOB_DEFINITION_FIELD, TRAINING_JOB_DEFINITIONS_FIELD, HYPER_PARAMETER_TUNING_JOB_STATUS_FIELD, CREATION_TIME_FIELD, HYPER_PARAMETER_TUNING_END_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, TRAINING_JOB_STATUS_COUNTERS_FIELD, OBJECTIVE_STATUS_COUNTERS_FIELD, BEST_TRAINING_JOB_FIELD, OVERALL_BEST_TRAINING_JOB_FIELD, WARM_START_CONFIG_FIELD, FAILURE_REASON_FIELD, TUNING_JOB_COMPLETION_DETAILS_FIELD, CONSUMED_RESOURCES_FIELD));
    private final String hyperParameterTuningJobName;
    private final String hyperParameterTuningJobArn;
    private final HyperParameterTuningJobConfig hyperParameterTuningJobConfig;
    private final HyperParameterTrainingJobDefinition trainingJobDefinition;
    private final List<HyperParameterTrainingJobDefinition> trainingJobDefinitions;
    private final String hyperParameterTuningJobStatus;
    private final Instant creationTime;
    private final Instant hyperParameterTuningEndTime;
    private final Instant lastModifiedTime;
    private final TrainingJobStatusCounters trainingJobStatusCounters;
    private final ObjectiveStatusCounters objectiveStatusCounters;
    private final HyperParameterTrainingJobSummary bestTrainingJob;
    private final HyperParameterTrainingJobSummary overallBestTrainingJob;
    private final HyperParameterTuningJobWarmStartConfig warmStartConfig;
    private final String failureReason;
    private final HyperParameterTuningJobCompletionDetails tuningJobCompletionDetails;
    private final HyperParameterTuningJobConsumedResources consumedResources;

    private DescribeHyperParameterTuningJobResponse(BuilderImpl builder) {
        super(builder);
        this.hyperParameterTuningJobName = builder.hyperParameterTuningJobName;
        this.hyperParameterTuningJobArn = builder.hyperParameterTuningJobArn;
        this.hyperParameterTuningJobConfig = builder.hyperParameterTuningJobConfig;
        this.trainingJobDefinition = builder.trainingJobDefinition;
        this.trainingJobDefinitions = builder.trainingJobDefinitions;
        this.hyperParameterTuningJobStatus = builder.hyperParameterTuningJobStatus;
        this.creationTime = builder.creationTime;
        this.hyperParameterTuningEndTime = builder.hyperParameterTuningEndTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.trainingJobStatusCounters = builder.trainingJobStatusCounters;
        this.objectiveStatusCounters = builder.objectiveStatusCounters;
        this.bestTrainingJob = builder.bestTrainingJob;
        this.overallBestTrainingJob = builder.overallBestTrainingJob;
        this.warmStartConfig = builder.warmStartConfig;
        this.failureReason = builder.failureReason;
        this.tuningJobCompletionDetails = builder.tuningJobCompletionDetails;
        this.consumedResources = builder.consumedResources;
    }

    public final String hyperParameterTuningJobName() {
        return this.hyperParameterTuningJobName;
    }

    public final String hyperParameterTuningJobArn() {
        return this.hyperParameterTuningJobArn;
    }

    public final HyperParameterTuningJobConfig hyperParameterTuningJobConfig() {
        return this.hyperParameterTuningJobConfig;
    }

    public final HyperParameterTrainingJobDefinition trainingJobDefinition() {
        return this.trainingJobDefinition;
    }

    public final boolean hasTrainingJobDefinitions() {
        return this.trainingJobDefinitions != null && !(this.trainingJobDefinitions instanceof SdkAutoConstructList);
    }

    public final List<HyperParameterTrainingJobDefinition> trainingJobDefinitions() {
        return this.trainingJobDefinitions;
    }

    public final HyperParameterTuningJobStatus hyperParameterTuningJobStatus() {
        return HyperParameterTuningJobStatus.fromValue(this.hyperParameterTuningJobStatus);
    }

    public final String hyperParameterTuningJobStatusAsString() {
        return this.hyperParameterTuningJobStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant hyperParameterTuningEndTime() {
        return this.hyperParameterTuningEndTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final TrainingJobStatusCounters trainingJobStatusCounters() {
        return this.trainingJobStatusCounters;
    }

    public final ObjectiveStatusCounters objectiveStatusCounters() {
        return this.objectiveStatusCounters;
    }

    public final HyperParameterTrainingJobSummary bestTrainingJob() {
        return this.bestTrainingJob;
    }

    public final HyperParameterTrainingJobSummary overallBestTrainingJob() {
        return this.overallBestTrainingJob;
    }

    public final HyperParameterTuningJobWarmStartConfig warmStartConfig() {
        return this.warmStartConfig;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final HyperParameterTuningJobCompletionDetails tuningJobCompletionDetails() {
        return this.tuningJobCompletionDetails;
    }

    public final HyperParameterTuningJobConsumedResources consumedResources() {
        return this.consumedResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTrainingJobDefinitions() ? this.trainingJobDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterTuningEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectiveStatusCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.bestTrainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.overallBestTrainingJob());
        hashCode = 31 * hashCode + Objects.hashCode(this.warmStartConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.tuningJobCompletionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumedResources());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHyperParameterTuningJobResponse)) {
            return false;
        }
        DescribeHyperParameterTuningJobResponse other = (DescribeHyperParameterTuningJobResponse)((Object)obj);
        return Objects.equals(this.hyperParameterTuningJobName(), other.hyperParameterTuningJobName()) && Objects.equals(this.hyperParameterTuningJobArn(), other.hyperParameterTuningJobArn()) && Objects.equals(this.hyperParameterTuningJobConfig(), other.hyperParameterTuningJobConfig()) && Objects.equals(this.trainingJobDefinition(), other.trainingJobDefinition()) && this.hasTrainingJobDefinitions() == other.hasTrainingJobDefinitions() && Objects.equals(this.trainingJobDefinitions(), other.trainingJobDefinitions()) && Objects.equals(this.hyperParameterTuningJobStatusAsString(), other.hyperParameterTuningJobStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.hyperParameterTuningEndTime(), other.hyperParameterTuningEndTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.trainingJobStatusCounters(), other.trainingJobStatusCounters()) && Objects.equals(this.objectiveStatusCounters(), other.objectiveStatusCounters()) && Objects.equals(this.bestTrainingJob(), other.bestTrainingJob()) && Objects.equals(this.overallBestTrainingJob(), other.overallBestTrainingJob()) && Objects.equals(this.warmStartConfig(), other.warmStartConfig()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.tuningJobCompletionDetails(), other.tuningJobCompletionDetails()) && Objects.equals(this.consumedResources(), other.consumedResources());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHyperParameterTuningJobResponse").add("HyperParameterTuningJobName", (Object)this.hyperParameterTuningJobName()).add("HyperParameterTuningJobArn", (Object)this.hyperParameterTuningJobArn()).add("HyperParameterTuningJobConfig", (Object)this.hyperParameterTuningJobConfig()).add("TrainingJobDefinition", (Object)this.trainingJobDefinition()).add("TrainingJobDefinitions", this.hasTrainingJobDefinitions() ? this.trainingJobDefinitions() : null).add("HyperParameterTuningJobStatus", (Object)this.hyperParameterTuningJobStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("HyperParameterTuningEndTime", (Object)this.hyperParameterTuningEndTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("TrainingJobStatusCounters", (Object)this.trainingJobStatusCounters()).add("ObjectiveStatusCounters", (Object)this.objectiveStatusCounters()).add("BestTrainingJob", (Object)this.bestTrainingJob()).add("OverallBestTrainingJob", (Object)this.overallBestTrainingJob()).add("WarmStartConfig", (Object)this.warmStartConfig()).add("FailureReason", (Object)this.failureReason()).add("TuningJobCompletionDetails", (Object)this.tuningJobCompletionDetails()).add("ConsumedResources", (Object)this.consumedResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HyperParameterTuningJobName": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobName()));
            }
            case "HyperParameterTuningJobArn": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobArn()));
            }
            case "HyperParameterTuningJobConfig": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobConfig()));
            }
            case "TrainingJobDefinition": {
                return Optional.ofNullable(clazz.cast(this.trainingJobDefinition()));
            }
            case "TrainingJobDefinitions": {
                return Optional.ofNullable(clazz.cast(this.trainingJobDefinitions()));
            }
            case "HyperParameterTuningJobStatus": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningJobStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "HyperParameterTuningEndTime": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterTuningEndTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "TrainingJobStatusCounters": {
                return Optional.ofNullable(clazz.cast(this.trainingJobStatusCounters()));
            }
            case "ObjectiveStatusCounters": {
                return Optional.ofNullable(clazz.cast(this.objectiveStatusCounters()));
            }
            case "BestTrainingJob": {
                return Optional.ofNullable(clazz.cast(this.bestTrainingJob()));
            }
            case "OverallBestTrainingJob": {
                return Optional.ofNullable(clazz.cast(this.overallBestTrainingJob()));
            }
            case "WarmStartConfig": {
                return Optional.ofNullable(clazz.cast(this.warmStartConfig()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "TuningJobCompletionDetails": {
                return Optional.ofNullable(clazz.cast(this.tuningJobCompletionDetails()));
            }
            case "ConsumedResources": {
                return Optional.ofNullable(clazz.cast(this.consumedResources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHyperParameterTuningJobResponse, T> g) {
        return obj -> g.apply((DescribeHyperParameterTuningJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String hyperParameterTuningJobName;
        private String hyperParameterTuningJobArn;
        private HyperParameterTuningJobConfig hyperParameterTuningJobConfig;
        private HyperParameterTrainingJobDefinition trainingJobDefinition;
        private List<HyperParameterTrainingJobDefinition> trainingJobDefinitions = DefaultSdkAutoConstructList.getInstance();
        private String hyperParameterTuningJobStatus;
        private Instant creationTime;
        private Instant hyperParameterTuningEndTime;
        private Instant lastModifiedTime;
        private TrainingJobStatusCounters trainingJobStatusCounters;
        private ObjectiveStatusCounters objectiveStatusCounters;
        private HyperParameterTrainingJobSummary bestTrainingJob;
        private HyperParameterTrainingJobSummary overallBestTrainingJob;
        private HyperParameterTuningJobWarmStartConfig warmStartConfig;
        private String failureReason;
        private HyperParameterTuningJobCompletionDetails tuningJobCompletionDetails;
        private HyperParameterTuningJobConsumedResources consumedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHyperParameterTuningJobResponse model) {
            super(model);
            this.hyperParameterTuningJobName(model.hyperParameterTuningJobName);
            this.hyperParameterTuningJobArn(model.hyperParameterTuningJobArn);
            this.hyperParameterTuningJobConfig(model.hyperParameterTuningJobConfig);
            this.trainingJobDefinition(model.trainingJobDefinition);
            this.trainingJobDefinitions(model.trainingJobDefinitions);
            this.hyperParameterTuningJobStatus(model.hyperParameterTuningJobStatus);
            this.creationTime(model.creationTime);
            this.hyperParameterTuningEndTime(model.hyperParameterTuningEndTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.trainingJobStatusCounters(model.trainingJobStatusCounters);
            this.objectiveStatusCounters(model.objectiveStatusCounters);
            this.bestTrainingJob(model.bestTrainingJob);
            this.overallBestTrainingJob(model.overallBestTrainingJob);
            this.warmStartConfig(model.warmStartConfig);
            this.failureReason(model.failureReason);
            this.tuningJobCompletionDetails(model.tuningJobCompletionDetails);
            this.consumedResources(model.consumedResources);
        }

        public final String getHyperParameterTuningJobName() {
            return this.hyperParameterTuningJobName;
        }

        public final void setHyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
        }

        @Override
        public final Builder hyperParameterTuningJobName(String hyperParameterTuningJobName) {
            this.hyperParameterTuningJobName = hyperParameterTuningJobName;
            return this;
        }

        public final String getHyperParameterTuningJobArn() {
            return this.hyperParameterTuningJobArn;
        }

        public final void setHyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
        }

        @Override
        public final Builder hyperParameterTuningJobArn(String hyperParameterTuningJobArn) {
            this.hyperParameterTuningJobArn = hyperParameterTuningJobArn;
            return this;
        }

        public final HyperParameterTuningJobConfig.Builder getHyperParameterTuningJobConfig() {
            return this.hyperParameterTuningJobConfig != null ? this.hyperParameterTuningJobConfig.toBuilder() : null;
        }

        public final void setHyperParameterTuningJobConfig(HyperParameterTuningJobConfig.BuilderImpl hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig != null ? hyperParameterTuningJobConfig.build() : null;
        }

        @Override
        public final Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig hyperParameterTuningJobConfig) {
            this.hyperParameterTuningJobConfig = hyperParameterTuningJobConfig;
            return this;
        }

        public final HyperParameterTrainingJobDefinition.Builder getTrainingJobDefinition() {
            return this.trainingJobDefinition != null ? this.trainingJobDefinition.toBuilder() : null;
        }

        public final void setTrainingJobDefinition(HyperParameterTrainingJobDefinition.BuilderImpl trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition != null ? trainingJobDefinition.build() : null;
        }

        @Override
        public final Builder trainingJobDefinition(HyperParameterTrainingJobDefinition trainingJobDefinition) {
            this.trainingJobDefinition = trainingJobDefinition;
            return this;
        }

        public final List<HyperParameterTrainingJobDefinition.Builder> getTrainingJobDefinitions() {
            List<HyperParameterTrainingJobDefinition.Builder> result = HyperParameterTrainingJobDefinitionsCopier.copyToBuilder(this.trainingJobDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition.BuilderImpl> trainingJobDefinitions) {
            this.trainingJobDefinitions = HyperParameterTrainingJobDefinitionsCopier.copyFromBuilder(trainingJobDefinitions);
        }

        @Override
        public final Builder trainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition> trainingJobDefinitions) {
            this.trainingJobDefinitions = HyperParameterTrainingJobDefinitionsCopier.copy(trainingJobDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobDefinitions(HyperParameterTrainingJobDefinition ... trainingJobDefinitions) {
            this.trainingJobDefinitions(Arrays.asList(trainingJobDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trainingJobDefinitions(Consumer<HyperParameterTrainingJobDefinition.Builder> ... trainingJobDefinitions) {
            this.trainingJobDefinitions(Stream.of(trainingJobDefinitions).map(c -> (HyperParameterTrainingJobDefinition)((HyperParameterTrainingJobDefinition.Builder)HyperParameterTrainingJobDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getHyperParameterTuningJobStatus() {
            return this.hyperParameterTuningJobStatus;
        }

        public final void setHyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(String hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus = hyperParameterTuningJobStatus;
            return this;
        }

        @Override
        public final Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus hyperParameterTuningJobStatus) {
            this.hyperParameterTuningJobStatus(hyperParameterTuningJobStatus == null ? null : hyperParameterTuningJobStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getHyperParameterTuningEndTime() {
            return this.hyperParameterTuningEndTime;
        }

        public final void setHyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
        }

        @Override
        public final Builder hyperParameterTuningEndTime(Instant hyperParameterTuningEndTime) {
            this.hyperParameterTuningEndTime = hyperParameterTuningEndTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final TrainingJobStatusCounters.Builder getTrainingJobStatusCounters() {
            return this.trainingJobStatusCounters != null ? this.trainingJobStatusCounters.toBuilder() : null;
        }

        public final void setTrainingJobStatusCounters(TrainingJobStatusCounters.BuilderImpl trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters != null ? trainingJobStatusCounters.build() : null;
        }

        @Override
        public final Builder trainingJobStatusCounters(TrainingJobStatusCounters trainingJobStatusCounters) {
            this.trainingJobStatusCounters = trainingJobStatusCounters;
            return this;
        }

        public final ObjectiveStatusCounters.Builder getObjectiveStatusCounters() {
            return this.objectiveStatusCounters != null ? this.objectiveStatusCounters.toBuilder() : null;
        }

        public final void setObjectiveStatusCounters(ObjectiveStatusCounters.BuilderImpl objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters != null ? objectiveStatusCounters.build() : null;
        }

        @Override
        public final Builder objectiveStatusCounters(ObjectiveStatusCounters objectiveStatusCounters) {
            this.objectiveStatusCounters = objectiveStatusCounters;
            return this;
        }

        public final HyperParameterTrainingJobSummary.Builder getBestTrainingJob() {
            return this.bestTrainingJob != null ? this.bestTrainingJob.toBuilder() : null;
        }

        public final void setBestTrainingJob(HyperParameterTrainingJobSummary.BuilderImpl bestTrainingJob) {
            this.bestTrainingJob = bestTrainingJob != null ? bestTrainingJob.build() : null;
        }

        @Override
        public final Builder bestTrainingJob(HyperParameterTrainingJobSummary bestTrainingJob) {
            this.bestTrainingJob = bestTrainingJob;
            return this;
        }

        public final HyperParameterTrainingJobSummary.Builder getOverallBestTrainingJob() {
            return this.overallBestTrainingJob != null ? this.overallBestTrainingJob.toBuilder() : null;
        }

        public final void setOverallBestTrainingJob(HyperParameterTrainingJobSummary.BuilderImpl overallBestTrainingJob) {
            this.overallBestTrainingJob = overallBestTrainingJob != null ? overallBestTrainingJob.build() : null;
        }

        @Override
        public final Builder overallBestTrainingJob(HyperParameterTrainingJobSummary overallBestTrainingJob) {
            this.overallBestTrainingJob = overallBestTrainingJob;
            return this;
        }

        public final HyperParameterTuningJobWarmStartConfig.Builder getWarmStartConfig() {
            return this.warmStartConfig != null ? this.warmStartConfig.toBuilder() : null;
        }

        public final void setWarmStartConfig(HyperParameterTuningJobWarmStartConfig.BuilderImpl warmStartConfig) {
            this.warmStartConfig = warmStartConfig != null ? warmStartConfig.build() : null;
        }

        @Override
        public final Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig warmStartConfig) {
            this.warmStartConfig = warmStartConfig;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final HyperParameterTuningJobCompletionDetails.Builder getTuningJobCompletionDetails() {
            return this.tuningJobCompletionDetails != null ? this.tuningJobCompletionDetails.toBuilder() : null;
        }

        public final void setTuningJobCompletionDetails(HyperParameterTuningJobCompletionDetails.BuilderImpl tuningJobCompletionDetails) {
            this.tuningJobCompletionDetails = tuningJobCompletionDetails != null ? tuningJobCompletionDetails.build() : null;
        }

        @Override
        public final Builder tuningJobCompletionDetails(HyperParameterTuningJobCompletionDetails tuningJobCompletionDetails) {
            this.tuningJobCompletionDetails = tuningJobCompletionDetails;
            return this;
        }

        public final HyperParameterTuningJobConsumedResources.Builder getConsumedResources() {
            return this.consumedResources != null ? this.consumedResources.toBuilder() : null;
        }

        public final void setConsumedResources(HyperParameterTuningJobConsumedResources.BuilderImpl consumedResources) {
            this.consumedResources = consumedResources != null ? consumedResources.build() : null;
        }

        @Override
        public final Builder consumedResources(HyperParameterTuningJobConsumedResources consumedResources) {
            this.consumedResources = consumedResources;
            return this;
        }

        @Override
        public DescribeHyperParameterTuningJobResponse build() {
            return new DescribeHyperParameterTuningJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHyperParameterTuningJobResponse> {
        public Builder hyperParameterTuningJobName(String var1);

        public Builder hyperParameterTuningJobArn(String var1);

        public Builder hyperParameterTuningJobConfig(HyperParameterTuningJobConfig var1);

        default public Builder hyperParameterTuningJobConfig(Consumer<HyperParameterTuningJobConfig.Builder> hyperParameterTuningJobConfig) {
            return this.hyperParameterTuningJobConfig((HyperParameterTuningJobConfig)((HyperParameterTuningJobConfig.Builder)HyperParameterTuningJobConfig.builder().applyMutation(hyperParameterTuningJobConfig)).build());
        }

        public Builder trainingJobDefinition(HyperParameterTrainingJobDefinition var1);

        default public Builder trainingJobDefinition(Consumer<HyperParameterTrainingJobDefinition.Builder> trainingJobDefinition) {
            return this.trainingJobDefinition((HyperParameterTrainingJobDefinition)((HyperParameterTrainingJobDefinition.Builder)HyperParameterTrainingJobDefinition.builder().applyMutation(trainingJobDefinition)).build());
        }

        public Builder trainingJobDefinitions(Collection<HyperParameterTrainingJobDefinition> var1);

        public Builder trainingJobDefinitions(HyperParameterTrainingJobDefinition ... var1);

        public Builder trainingJobDefinitions(Consumer<HyperParameterTrainingJobDefinition.Builder> ... var1);

        public Builder hyperParameterTuningJobStatus(String var1);

        public Builder hyperParameterTuningJobStatus(HyperParameterTuningJobStatus var1);

        public Builder creationTime(Instant var1);

        public Builder hyperParameterTuningEndTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder trainingJobStatusCounters(TrainingJobStatusCounters var1);

        default public Builder trainingJobStatusCounters(Consumer<TrainingJobStatusCounters.Builder> trainingJobStatusCounters) {
            return this.trainingJobStatusCounters((TrainingJobStatusCounters)((TrainingJobStatusCounters.Builder)TrainingJobStatusCounters.builder().applyMutation(trainingJobStatusCounters)).build());
        }

        public Builder objectiveStatusCounters(ObjectiveStatusCounters var1);

        default public Builder objectiveStatusCounters(Consumer<ObjectiveStatusCounters.Builder> objectiveStatusCounters) {
            return this.objectiveStatusCounters((ObjectiveStatusCounters)((ObjectiveStatusCounters.Builder)ObjectiveStatusCounters.builder().applyMutation(objectiveStatusCounters)).build());
        }

        public Builder bestTrainingJob(HyperParameterTrainingJobSummary var1);

        default public Builder bestTrainingJob(Consumer<HyperParameterTrainingJobSummary.Builder> bestTrainingJob) {
            return this.bestTrainingJob((HyperParameterTrainingJobSummary)((HyperParameterTrainingJobSummary.Builder)HyperParameterTrainingJobSummary.builder().applyMutation(bestTrainingJob)).build());
        }

        public Builder overallBestTrainingJob(HyperParameterTrainingJobSummary var1);

        default public Builder overallBestTrainingJob(Consumer<HyperParameterTrainingJobSummary.Builder> overallBestTrainingJob) {
            return this.overallBestTrainingJob((HyperParameterTrainingJobSummary)((HyperParameterTrainingJobSummary.Builder)HyperParameterTrainingJobSummary.builder().applyMutation(overallBestTrainingJob)).build());
        }

        public Builder warmStartConfig(HyperParameterTuningJobWarmStartConfig var1);

        default public Builder warmStartConfig(Consumer<HyperParameterTuningJobWarmStartConfig.Builder> warmStartConfig) {
            return this.warmStartConfig((HyperParameterTuningJobWarmStartConfig)((HyperParameterTuningJobWarmStartConfig.Builder)HyperParameterTuningJobWarmStartConfig.builder().applyMutation(warmStartConfig)).build());
        }

        public Builder failureReason(String var1);

        public Builder tuningJobCompletionDetails(HyperParameterTuningJobCompletionDetails var1);

        default public Builder tuningJobCompletionDetails(Consumer<HyperParameterTuningJobCompletionDetails.Builder> tuningJobCompletionDetails) {
            return this.tuningJobCompletionDetails((HyperParameterTuningJobCompletionDetails)((HyperParameterTuningJobCompletionDetails.Builder)HyperParameterTuningJobCompletionDetails.builder().applyMutation(tuningJobCompletionDetails)).build());
        }

        public Builder consumedResources(HyperParameterTuningJobConsumedResources var1);

        default public Builder consumedResources(Consumer<HyperParameterTuningJobConsumedResources.Builder> consumedResources) {
            return this.consumedResources((HyperParameterTuningJobConsumedResources)((HyperParameterTuningJobConsumedResources.Builder)HyperParameterTuningJobConsumedResources.builder().applyMutation(consumedResources)).build());
        }
    }
}

