/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.MetadataProperties;
import software.amazon.awssdk.services.sagemaker.model.Parent;
import software.amazon.awssdk.services.sagemaker.model.ParentsCopier;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifact;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentArtifactsCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentMetricSummary;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentParameterValue;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSource;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentSourceDetail;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentStatus;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrialComponent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrialComponent> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialComponentName").getter(TrialComponent.getter(TrialComponent::trialComponentName)).setter(TrialComponent.setter(Builder::trialComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(TrialComponent.getter(TrialComponent::displayName)).setter(TrialComponent.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<String> TRIAL_COMPONENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialComponentArn").getter(TrialComponent.getter(TrialComponent::trialComponentArn)).setter(TrialComponent.setter(Builder::trialComponentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentArn").build()}).build();
    private static final SdkField<TrialComponentSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(TrialComponent.getter(TrialComponent::source)).setter(TrialComponent.setter(Builder::source)).constructor(TrialComponentSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Status").getter(TrialComponent.getter(TrialComponent::status)).setter(TrialComponent.setter(Builder::status)).constructor(TrialComponentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(TrialComponent.getter(TrialComponent::startTime)).setter(TrialComponent.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(TrialComponent.getter(TrialComponent::endTime)).setter(TrialComponent.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TrialComponent.getter(TrialComponent::creationTime)).setter(TrialComponent.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(TrialComponent.getter(TrialComponent::createdBy)).setter(TrialComponent.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(TrialComponent.getter(TrialComponent::lastModifiedTime)).setter(TrialComponent.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(TrialComponent.getter(TrialComponent::lastModifiedBy)).setter(TrialComponent.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final SdkField<Map<String, TrialComponentParameterValue>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Parameters").getter(TrialComponent.getter(TrialComponent::parameters)).setter(TrialComponent.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentParameterValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, TrialComponentArtifact>> INPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("InputArtifacts").getter(TrialComponent.getter(TrialComponent::inputArtifacts)).setter(TrialComponent.setter(Builder::inputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifacts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, TrialComponentArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OutputArtifacts").getter(TrialComponent.getter(TrialComponent::outputArtifacts)).setter(TrialComponent.setter(Builder::outputArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifacts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<TrialComponentMetricSummary>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(TrialComponent.getter(TrialComponent::metrics)).setter(TrialComponent.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TrialComponentMetricSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MetadataProperties").getter(TrialComponent.getter(TrialComponent::metadataProperties)).setter(TrialComponent.setter(Builder::metadataProperties)).constructor(MetadataProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build()}).build();
    private static final SdkField<TrialComponentSourceDetail> SOURCE_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceDetail").getter(TrialComponent.getter(TrialComponent::sourceDetail)).setter(TrialComponent.setter(Builder::sourceDetail)).constructor(TrialComponentSourceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDetail").build()}).build();
    private static final SdkField<String> LINEAGE_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LineageGroupArn").getter(TrialComponent.getter(TrialComponent::lineageGroupArn)).setter(TrialComponent.setter(Builder::lineageGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageGroupArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TrialComponent.getter(TrialComponent::tags)).setter(TrialComponent.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Parent>> PARENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parents").getter(TrialComponent.getter(TrialComponent::parents)).setter(TrialComponent.setter(Builder::parents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Parent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RUN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RunName").getter(TrialComponent.getter(TrialComponent::runName)).setter(TrialComponent.setter(Builder::runName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RunName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD, DISPLAY_NAME_FIELD, TRIAL_COMPONENT_ARN_FIELD, SOURCE_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD, PARAMETERS_FIELD, INPUT_ARTIFACTS_FIELD, OUTPUT_ARTIFACTS_FIELD, METRICS_FIELD, METADATA_PROPERTIES_FIELD, SOURCE_DETAIL_FIELD, LINEAGE_GROUP_ARN_FIELD, TAGS_FIELD, PARENTS_FIELD, RUN_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trialComponentName;
    private final String displayName;
    private final String trialComponentArn;
    private final TrialComponentSource source;
    private final TrialComponentStatus status;
    private final Instant startTime;
    private final Instant endTime;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;
    private final Map<String, TrialComponentParameterValue> parameters;
    private final Map<String, TrialComponentArtifact> inputArtifacts;
    private final Map<String, TrialComponentArtifact> outputArtifacts;
    private final List<TrialComponentMetricSummary> metrics;
    private final MetadataProperties metadataProperties;
    private final TrialComponentSourceDetail sourceDetail;
    private final String lineageGroupArn;
    private final List<Tag> tags;
    private final List<Parent> parents;
    private final String runName;

    private TrialComponent(BuilderImpl builder) {
        this.trialComponentName = builder.trialComponentName;
        this.displayName = builder.displayName;
        this.trialComponentArn = builder.trialComponentArn;
        this.source = builder.source;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.parameters = builder.parameters;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.metrics = builder.metrics;
        this.metadataProperties = builder.metadataProperties;
        this.sourceDetail = builder.sourceDetail;
        this.lineageGroupArn = builder.lineageGroupArn;
        this.tags = builder.tags;
        this.parents = builder.parents;
        this.runName = builder.runName;
    }

    public final String trialComponentName() {
        return this.trialComponentName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String trialComponentArn() {
        return this.trialComponentArn;
    }

    public final TrialComponentSource source() {
        return this.source;
    }

    public final TrialComponentStatus status() {
        return this.status;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, TrialComponentParameterValue> parameters() {
        return this.parameters;
    }

    public final boolean hasInputArtifacts() {
        return this.inputArtifacts != null && !(this.inputArtifacts instanceof SdkAutoConstructMap);
    }

    public final Map<String, TrialComponentArtifact> inputArtifacts() {
        return this.inputArtifacts;
    }

    public final boolean hasOutputArtifacts() {
        return this.outputArtifacts != null && !(this.outputArtifacts instanceof SdkAutoConstructMap);
    }

    public final Map<String, TrialComponentArtifact> outputArtifacts() {
        return this.outputArtifacts;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<TrialComponentMetricSummary> metrics() {
        return this.metrics;
    }

    public final MetadataProperties metadataProperties() {
        return this.metadataProperties;
    }

    public final TrialComponentSourceDetail sourceDetail() {
        return this.sourceDetail;
    }

    public final String lineageGroupArn() {
        return this.lineageGroupArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasParents() {
        return this.parents != null && !(this.parents instanceof SdkAutoConstructList);
    }

    public final List<Parent> parents() {
        return this.parents;
    }

    public final String runName() {
        return this.runName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputArtifacts() ? this.inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputArtifacts() ? this.outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParents() ? this.parents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponent)) {
            return false;
        }
        TrialComponent other = (TrialComponent)obj;
        return Objects.equals(this.trialComponentName(), other.trialComponentName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.trialComponentArn(), other.trialComponentArn()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && this.hasInputArtifacts() == other.hasInputArtifacts() && Objects.equals(this.inputArtifacts(), other.inputArtifacts()) && this.hasOutputArtifacts() == other.hasOutputArtifacts() && Objects.equals(this.outputArtifacts(), other.outputArtifacts()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.metadataProperties(), other.metadataProperties()) && Objects.equals(this.sourceDetail(), other.sourceDetail()) && Objects.equals(this.lineageGroupArn(), other.lineageGroupArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasParents() == other.hasParents() && Objects.equals(this.parents(), other.parents()) && Objects.equals(this.runName(), other.runName());
    }

    public final String toString() {
        return ToString.builder((String)"TrialComponent").add("TrialComponentName", (Object)this.trialComponentName()).add("DisplayName", (Object)this.displayName()).add("TrialComponentArn", (Object)this.trialComponentArn()).add("Source", (Object)this.source()).add("Status", (Object)this.status()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("InputArtifacts", this.hasInputArtifacts() ? this.inputArtifacts() : null).add("OutputArtifacts", this.hasOutputArtifacts() ? this.outputArtifacts() : null).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("MetadataProperties", (Object)this.metadataProperties()).add("SourceDetail", (Object)this.sourceDetail()).add("LineageGroupArn", (Object)this.lineageGroupArn()).add("Tags", this.hasTags() ? this.tags() : null).add("Parents", this.hasParents() ? this.parents() : null).add("RunName", (Object)this.runName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialComponentName": {
                return Optional.ofNullable(clazz.cast(this.trialComponentName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "TrialComponentArn": {
                return Optional.ofNullable(clazz.cast(this.trialComponentArn()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "InputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.inputArtifacts()));
            }
            case "OutputArtifacts": {
                return Optional.ofNullable(clazz.cast(this.outputArtifacts()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "MetadataProperties": {
                return Optional.ofNullable(clazz.cast(this.metadataProperties()));
            }
            case "SourceDetail": {
                return Optional.ofNullable(clazz.cast(this.sourceDetail()));
            }
            case "LineageGroupArn": {
                return Optional.ofNullable(clazz.cast(this.lineageGroupArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Parents": {
                return Optional.ofNullable(clazz.cast(this.parents()));
            }
            case "RunName": {
                return Optional.ofNullable(clazz.cast(this.runName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponent, T> g) {
        return obj -> g.apply((TrialComponent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trialComponentName;
        private String displayName;
        private String trialComponentArn;
        private TrialComponentSource source;
        private TrialComponentStatus status;
        private Instant startTime;
        private Instant endTime;
        private Instant creationTime;
        private UserContext createdBy;
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;
        private Map<String, TrialComponentParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, TrialComponentArtifact> inputArtifacts = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, TrialComponentArtifact> outputArtifacts = DefaultSdkAutoConstructMap.getInstance();
        private List<TrialComponentMetricSummary> metrics = DefaultSdkAutoConstructList.getInstance();
        private MetadataProperties metadataProperties;
        private TrialComponentSourceDetail sourceDetail;
        private String lineageGroupArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<Parent> parents = DefaultSdkAutoConstructList.getInstance();
        private String runName;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponent model) {
            this.trialComponentName(model.trialComponentName);
            this.displayName(model.displayName);
            this.trialComponentArn(model.trialComponentArn);
            this.source(model.source);
            this.status(model.status);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
            this.parameters(model.parameters);
            this.inputArtifacts(model.inputArtifacts);
            this.outputArtifacts(model.outputArtifacts);
            this.metrics(model.metrics);
            this.metadataProperties(model.metadataProperties);
            this.sourceDetail(model.sourceDetail);
            this.lineageGroupArn(model.lineageGroupArn);
            this.tags(model.tags);
            this.parents(model.parents);
            this.runName(model.runName);
        }

        public final String getTrialComponentName() {
            return this.trialComponentName;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getTrialComponentArn() {
            return this.trialComponentArn;
        }

        public final void setTrialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
        }

        @Override
        public final Builder trialComponentArn(String trialComponentArn) {
            this.trialComponentArn = trialComponentArn;
            return this;
        }

        public final TrialComponentSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(TrialComponentSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(TrialComponentSource source) {
            this.source = source;
            return this;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final Map<String, TrialComponentParameterValue.Builder> getParameters() {
            Map<String, TrialComponentParameterValue.Builder> result = TrialComponentParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, TrialComponentParameterValue.BuilderImpl> parameters) {
            this.parameters = TrialComponentParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, TrialComponentParameterValue> parameters) {
            this.parameters = TrialComponentParametersCopier.copy(parameters);
            return this;
        }

        public final Map<String, TrialComponentArtifact.Builder> getInputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(inputArtifacts);
        }

        @Override
        public final Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copy(inputArtifacts);
            return this;
        }

        public final Map<String, TrialComponentArtifact.Builder> getOutputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier.copyToBuilder(this.outputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOutputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(outputArtifacts);
        }

        @Override
        public final Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copy(outputArtifacts);
            return this;
        }

        public final List<TrialComponentMetricSummary.Builder> getMetrics() {
            List<TrialComponentMetricSummary.Builder> result = TrialComponentMetricSummariesCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<TrialComponentMetricSummary.BuilderImpl> metrics) {
            this.metrics = TrialComponentMetricSummariesCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<TrialComponentMetricSummary> metrics) {
            this.metrics = TrialComponentMetricSummariesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(TrialComponentMetricSummary ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<TrialComponentMetricSummary.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (TrialComponentMetricSummary)((TrialComponentMetricSummary.Builder)TrialComponentMetricSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return this.metadataProperties != null ? this.metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final TrialComponentSourceDetail.Builder getSourceDetail() {
            return this.sourceDetail != null ? this.sourceDetail.toBuilder() : null;
        }

        public final void setSourceDetail(TrialComponentSourceDetail.BuilderImpl sourceDetail) {
            this.sourceDetail = sourceDetail != null ? sourceDetail.build() : null;
        }

        @Override
        public final Builder sourceDetail(TrialComponentSourceDetail sourceDetail) {
            this.sourceDetail = sourceDetail;
            return this;
        }

        public final String getLineageGroupArn() {
            return this.lineageGroupArn;
        }

        public final void setLineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
        }

        @Override
        public final Builder lineageGroupArn(String lineageGroupArn) {
            this.lineageGroupArn = lineageGroupArn;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Parent.Builder> getParents() {
            List<Parent.Builder> result = ParentsCopier.copyToBuilder(this.parents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParents(Collection<Parent.BuilderImpl> parents) {
            this.parents = ParentsCopier.copyFromBuilder(parents);
        }

        @Override
        public final Builder parents(Collection<Parent> parents) {
            this.parents = ParentsCopier.copy(parents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Parent ... parents) {
            this.parents(Arrays.asList(parents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(Consumer<Parent.Builder> ... parents) {
            this.parents(Stream.of(parents).map(c -> (Parent)((Parent.Builder)Parent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRunName() {
            return this.runName;
        }

        public final void setRunName(String runName) {
            this.runName = runName;
        }

        @Override
        public final Builder runName(String runName) {
            this.runName = runName;
            return this;
        }

        public TrialComponent build() {
            return new TrialComponent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrialComponent> {
        public Builder trialComponentName(String var1);

        public Builder displayName(String var1);

        public Builder trialComponentArn(String var1);

        public Builder source(TrialComponentSource var1);

        default public Builder source(Consumer<TrialComponentSource.Builder> source) {
            return this.source((TrialComponentSource)((TrialComponentSource.Builder)TrialComponentSource.builder().applyMutation(source)).build());
        }

        public Builder status(TrialComponentStatus var1);

        default public Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return this.status((TrialComponentStatus)((TrialComponentStatus.Builder)TrialComponentStatus.builder().applyMutation(status)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }

        public Builder parameters(Map<String, TrialComponentParameterValue> var1);

        public Builder inputArtifacts(Map<String, TrialComponentArtifact> var1);

        public Builder outputArtifacts(Map<String, TrialComponentArtifact> var1);

        public Builder metrics(Collection<TrialComponentMetricSummary> var1);

        public Builder metrics(TrialComponentMetricSummary ... var1);

        public Builder metrics(Consumer<TrialComponentMetricSummary.Builder> ... var1);

        public Builder metadataProperties(MetadataProperties var1);

        default public Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return this.metadataProperties((MetadataProperties)((MetadataProperties.Builder)MetadataProperties.builder().applyMutation(metadataProperties)).build());
        }

        public Builder sourceDetail(TrialComponentSourceDetail var1);

        default public Builder sourceDetail(Consumer<TrialComponentSourceDetail.Builder> sourceDetail) {
            return this.sourceDetail((TrialComponentSourceDetail)((TrialComponentSourceDetail.Builder)TrialComponentSourceDetail.builder().applyMutation(sourceDetail)).build());
        }

        public Builder lineageGroupArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder parents(Collection<Parent> var1);

        public Builder parents(Parent ... var1);

        public Builder parents(Consumer<Parent.Builder> ... var1);

        public Builder runName(String var1);
    }
}

