/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.InputConfig;
import software.amazon.awssdk.services.sagemaker.model.NeoVpcConfig;
import software.amazon.awssdk.services.sagemaker.model.OutputConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCompilationJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateCompilationJobRequest> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilationJobName").getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::compilationJobName)).setter(CreateCompilationJobRequest.setter(Builder::compilationJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::roleArn)).setter(CreateCompilationJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> MODEL_PACKAGE_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelPackageVersionArn").getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::modelPackageVersionArn)).setter(CreateCompilationJobRequest.setter(Builder::modelPackageVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersionArn").build()}).build();
    private static final SdkField<InputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::inputConfig)).setter(CreateCompilationJobRequest.setter(Builder::inputConfig)).constructor(InputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::outputConfig)).setter(CreateCompilationJobRequest.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<NeoVpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::vpcConfig)).setter(CreateCompilationJobRequest.setter(Builder::vpcConfig)).constructor(NeoVpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::stoppingCondition)).setter(CreateCompilationJobRequest.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateCompilationJobRequest.getter(CreateCompilationJobRequest::tags)).setter(CreateCompilationJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD, ROLE_ARN_FIELD, MODEL_PACKAGE_VERSION_ARN_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, VPC_CONFIG_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD));
    private final String compilationJobName;
    private final String roleArn;
    private final String modelPackageVersionArn;
    private final InputConfig inputConfig;
    private final OutputConfig outputConfig;
    private final NeoVpcConfig vpcConfig;
    private final StoppingCondition stoppingCondition;
    private final List<Tag> tags;

    private CreateCompilationJobRequest(BuilderImpl builder) {
        super(builder);
        this.compilationJobName = builder.compilationJobName;
        this.roleArn = builder.roleArn;
        this.modelPackageVersionArn = builder.modelPackageVersionArn;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.vpcConfig = builder.vpcConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    public final String compilationJobName() {
        return this.compilationJobName;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String modelPackageVersionArn() {
        return this.modelPackageVersionArn;
    }

    public final InputConfig inputConfig() {
        return this.inputConfig;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final NeoVpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelPackageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCompilationJobRequest)) {
            return false;
        }
        CreateCompilationJobRequest other = (CreateCompilationJobRequest)((Object)obj);
        return Objects.equals(this.compilationJobName(), other.compilationJobName()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.modelPackageVersionArn(), other.modelPackageVersionArn()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCompilationJobRequest").add("CompilationJobName", (Object)this.compilationJobName()).add("RoleArn", (Object)this.roleArn()).add("ModelPackageVersionArn", (Object)this.modelPackageVersionArn()).add("InputConfig", (Object)this.inputConfig()).add("OutputConfig", (Object)this.outputConfig()).add("VpcConfig", (Object)this.vpcConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CompilationJobName": {
                return Optional.ofNullable(clazz.cast(this.compilationJobName()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ModelPackageVersionArn": {
                return Optional.ofNullable(clazz.cast(this.modelPackageVersionArn()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCompilationJobRequest, T> g) {
        return obj -> g.apply((CreateCompilationJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String compilationJobName;
        private String roleArn;
        private String modelPackageVersionArn;
        private InputConfig inputConfig;
        private OutputConfig outputConfig;
        private NeoVpcConfig vpcConfig;
        private StoppingCondition stoppingCondition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCompilationJobRequest model) {
            super(model);
            this.compilationJobName(model.compilationJobName);
            this.roleArn(model.roleArn);
            this.modelPackageVersionArn(model.modelPackageVersionArn);
            this.inputConfig(model.inputConfig);
            this.outputConfig(model.outputConfig);
            this.vpcConfig(model.vpcConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.tags(model.tags);
        }

        public final String getCompilationJobName() {
            return this.compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getModelPackageVersionArn() {
            return this.modelPackageVersionArn;
        }

        public final void setModelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
        }

        @Override
        public final Builder modelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
            return this;
        }

        public final InputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(InputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(InputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final NeoVpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(NeoVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(NeoVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCompilationJobRequest build() {
            return new CreateCompilationJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCompilationJobRequest> {
        public Builder compilationJobName(String var1);

        public Builder roleArn(String var1);

        public Builder modelPackageVersionArn(String var1);

        public Builder inputConfig(InputConfig var1);

        default public Builder inputConfig(Consumer<InputConfig.Builder> inputConfig) {
            return this.inputConfig((InputConfig)((InputConfig.Builder)InputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder vpcConfig(NeoVpcConfig var1);

        default public Builder vpcConfig(Consumer<NeoVpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((NeoVpcConfig)((NeoVpcConfig.Builder)NeoVpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

