/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.AutoMLCandidate;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCandidatesForAutoMlJobResponse;

public class ListCandidatesForAutoMLJobPublisher
implements SdkPublisher<ListCandidatesForAutoMlJobResponse> {
    private final SageMakerAsyncClient client;
    private final ListCandidatesForAutoMlJobRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCandidatesForAutoMLJobPublisher(SageMakerAsyncClient client, ListCandidatesForAutoMlJobRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCandidatesForAutoMLJobPublisher(SageMakerAsyncClient client, ListCandidatesForAutoMlJobRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCandidatesForAutoMlJobResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCandidatesForAutoMlJobResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutoMLCandidate> candidates() {
        Function<ListCandidatesForAutoMlJobResponse, Iterator> getIterator = response -> {
            if (response != null && response.candidates() != null) {
                return response.candidates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCandidatesForAutoMlJobResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCandidatesForAutoMlJobResponseFetcher
    implements AsyncPageFetcher<ListCandidatesForAutoMlJobResponse> {
        private ListCandidatesForAutoMlJobResponseFetcher() {
        }

        public boolean hasNextPage(ListCandidatesForAutoMlJobResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCandidatesForAutoMlJobResponse> nextPage(ListCandidatesForAutoMlJobResponse previousPage) {
            if (previousPage == null) {
                return ListCandidatesForAutoMLJobPublisher.this.client.listCandidatesForAutoMLJob(ListCandidatesForAutoMLJobPublisher.this.firstRequest);
            }
            return ListCandidatesForAutoMLJobPublisher.this.client.listCandidatesForAutoMLJob((ListCandidatesForAutoMlJobRequest)((Object)ListCandidatesForAutoMLJobPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

