/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.CustomizedMetricSpecification;
import software.amazon.awssdk.services.sagemaker.model.PredefinedMetricSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricSpecification> {
    private static final SdkField<PredefinedMetricSpecification> PREDEFINED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Predefined").getter(MetricSpecification.getter(MetricSpecification::predefined)).setter(MetricSpecification.setter(Builder::predefined)).constructor(PredefinedMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predefined").build()}).build();
    private static final SdkField<CustomizedMetricSpecification> CUSTOMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Customized").getter(MetricSpecification.getter(MetricSpecification::customized)).setter(MetricSpecification.setter(Builder::customized)).constructor(CustomizedMetricSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customized").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_FIELD, CUSTOMIZED_FIELD));
    private static final long serialVersionUID = 1L;
    private final PredefinedMetricSpecification predefined;
    private final CustomizedMetricSpecification customized;
    private final Type type;

    private MetricSpecification(BuilderImpl builder) {
        this.predefined = builder.predefined;
        this.customized = builder.customized;
        this.type = builder.type;
    }

    public final PredefinedMetricSpecification predefined() {
        return this.predefined;
    }

    public final CustomizedMetricSpecification customized() {
        return this.customized;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.predefined());
        hashCode = 31 * hashCode + Objects.hashCode(this.customized());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSpecification)) {
            return false;
        }
        MetricSpecification other = (MetricSpecification)obj;
        return Objects.equals(this.predefined(), other.predefined()) && Objects.equals(this.customized(), other.customized());
    }

    public final String toString() {
        return ToString.builder((String)"MetricSpecification").add("Predefined", (Object)this.predefined()).add("Customized", (Object)this.customized()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Predefined": {
                return Optional.ofNullable(clazz.cast(this.predefined()));
            }
            case "Customized": {
                return Optional.ofNullable(clazz.cast(this.customized()));
            }
        }
        return Optional.empty();
    }

    public static MetricSpecification fromPredefined(PredefinedMetricSpecification predefined) {
        return (MetricSpecification)MetricSpecification.builder().predefined(predefined).build();
    }

    public static MetricSpecification fromPredefined(Consumer<PredefinedMetricSpecification.Builder> predefined) {
        PredefinedMetricSpecification.Builder builder = PredefinedMetricSpecification.builder();
        predefined.accept(builder);
        return MetricSpecification.fromPredefined((PredefinedMetricSpecification)builder.build());
    }

    public static MetricSpecification fromCustomized(CustomizedMetricSpecification customized) {
        return (MetricSpecification)MetricSpecification.builder().customized(customized).build();
    }

    public static MetricSpecification fromCustomized(Consumer<CustomizedMetricSpecification.Builder> customized) {
        CustomizedMetricSpecification.Builder builder = CustomizedMetricSpecification.builder();
        customized.accept(builder);
        return MetricSpecification.fromCustomized((CustomizedMetricSpecification)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricSpecification, T> g) {
        return obj -> g.apply((MetricSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PREDEFINED,
        CUSTOMIZED,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private PredefinedMetricSpecification predefined;
        private CustomizedMetricSpecification customized;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSpecification model) {
            this.predefined(model.predefined);
            this.customized(model.customized);
        }

        public final PredefinedMetricSpecification.Builder getPredefined() {
            return this.predefined != null ? this.predefined.toBuilder() : null;
        }

        public final void setPredefined(PredefinedMetricSpecification.BuilderImpl predefined) {
            PredefinedMetricSpecification oldValue = this.predefined;
            this.predefined = predefined != null ? predefined.build() : null;
            this.handleUnionValueChange(Type.PREDEFINED, oldValue, this.predefined);
        }

        @Override
        public final Builder predefined(PredefinedMetricSpecification predefined) {
            PredefinedMetricSpecification oldValue = this.predefined;
            this.predefined = predefined;
            this.handleUnionValueChange(Type.PREDEFINED, oldValue, this.predefined);
            return this;
        }

        public final CustomizedMetricSpecification.Builder getCustomized() {
            return this.customized != null ? this.customized.toBuilder() : null;
        }

        public final void setCustomized(CustomizedMetricSpecification.BuilderImpl customized) {
            CustomizedMetricSpecification oldValue = this.customized;
            this.customized = customized != null ? customized.build() : null;
            this.handleUnionValueChange(Type.CUSTOMIZED, oldValue, this.customized);
        }

        @Override
        public final Builder customized(CustomizedMetricSpecification customized) {
            CustomizedMetricSpecification oldValue = this.customized;
            this.customized = customized;
            this.handleUnionValueChange(Type.CUSTOMIZED, oldValue, this.customized);
            return this;
        }

        public MetricSpecification build() {
            return new MetricSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricSpecification> {
        public Builder predefined(PredefinedMetricSpecification var1);

        default public Builder predefined(Consumer<PredefinedMetricSpecification.Builder> predefined) {
            return this.predefined((PredefinedMetricSpecification)((PredefinedMetricSpecification.Builder)PredefinedMetricSpecification.builder().applyMutation(predefined)).build());
        }

        public Builder customized(CustomizedMetricSpecification var1);

        default public Builder customized(Consumer<CustomizedMetricSpecification.Builder> customized) {
            return this.customized((CustomizedMetricSpecification)((CustomizedMetricSpecification.Builder)CustomizedMetricSpecification.builder().applyMutation(customized)).build());
        }
    }
}

