/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InferenceExperimentType {
    SHADOW_MODE("ShadowMode"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InferenceExperimentType> VALUE_MAP;
    private final String value;

    private InferenceExperimentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InferenceExperimentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InferenceExperimentType> knownValues() {
        EnumSet<InferenceExperimentType> knownValues = EnumSet.allOf(InferenceExperimentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InferenceExperimentType.class, InferenceExperimentType::toString);
    }
}

