/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClarifyTextGranularity;
import software.amazon.awssdk.services.sagemaker.model.ClarifyTextLanguage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClarifyTextConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClarifyTextConfig> {
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Language").getter(ClarifyTextConfig.getter(ClarifyTextConfig::languageAsString)).setter(ClarifyTextConfig.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Language").build()}).build();
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Granularity").getter(ClarifyTextConfig.getter(ClarifyTextConfig::granularityAsString)).setter(ClarifyTextConfig.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_FIELD, GRANULARITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String language;
    private final String granularity;

    private ClarifyTextConfig(BuilderImpl builder) {
        this.language = builder.language;
        this.granularity = builder.granularity;
    }

    public final ClarifyTextLanguage language() {
        return ClarifyTextLanguage.fromValue(this.language);
    }

    public final String languageAsString() {
        return this.language;
    }

    public final ClarifyTextGranularity granularity() {
        return ClarifyTextGranularity.fromValue(this.granularity);
    }

    public final String granularityAsString() {
        return this.granularity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyTextConfig)) {
            return false;
        }
        ClarifyTextConfig other = (ClarifyTextConfig)obj;
        return Objects.equals(this.languageAsString(), other.languageAsString()) && Objects.equals(this.granularityAsString(), other.granularityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ClarifyTextConfig").add("Language", (Object)this.languageAsString()).add("Granularity", (Object)this.granularityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Language": {
                return Optional.ofNullable(clazz.cast(this.languageAsString()));
            }
            case "Granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClarifyTextConfig, T> g) {
        return obj -> g.apply((ClarifyTextConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String language;
        private String granularity;

        private BuilderImpl() {
        }

        private BuilderImpl(ClarifyTextConfig model) {
            this.language(model.language);
            this.granularity(model.granularity);
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(ClarifyTextLanguage language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(ClarifyTextGranularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public ClarifyTextConfig build() {
            return new ClarifyTextConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClarifyTextConfig> {
        public Builder language(String var1);

        public Builder language(ClarifyTextLanguage var1);

        public Builder granularity(String var1);

        public Builder granularity(ClarifyTextGranularity var1);
    }
}

