/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardExportJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelCardExportJobSummary;

public class ListModelCardExportJobsPublisher
implements SdkPublisher<ListModelCardExportJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListModelCardExportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelCardExportJobsPublisher(SageMakerAsyncClient client, ListModelCardExportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelCardExportJobsPublisher(SageMakerAsyncClient client, ListModelCardExportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelCardExportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelCardExportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelCardExportJobSummary> modelCardExportJobSummaries() {
        Function<ListModelCardExportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelCardExportJobSummaries() != null) {
                return response.modelCardExportJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelCardExportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelCardExportJobsResponseFetcher
    implements AsyncPageFetcher<ListModelCardExportJobsResponse> {
        private ListModelCardExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCardExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelCardExportJobsResponse> nextPage(ListModelCardExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCardExportJobsPublisher.this.client.listModelCardExportJobs(ListModelCardExportJobsPublisher.this.firstRequest);
            }
            return ListModelCardExportJobsPublisher.this.client.listModelCardExportJobs((ListModelCardExportJobsRequest)((Object)ListModelCardExportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

