/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureHeadersCopier;
import software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureType;
import software.amazon.awssdk.services.sagemaker.model.ClarifyFeatureTypesCopier;
import software.amazon.awssdk.services.sagemaker.model.ClarifyLabelHeadersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClarifyInferenceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClarifyInferenceConfig> {
    private static final SdkField<String> FEATURES_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeaturesAttribute").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::featuresAttribute)).setter(ClarifyInferenceConfig.setter(Builder::featuresAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeaturesAttribute").build()}).build();
    private static final SdkField<String> CONTENT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentTemplate").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::contentTemplate)).setter(ClarifyInferenceConfig.setter(Builder::contentTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentTemplate").build()}).build();
    private static final SdkField<Integer> MAX_RECORD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxRecordCount").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::maxRecordCount)).setter(ClarifyInferenceConfig.setter(Builder::maxRecordCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecordCount").build()}).build();
    private static final SdkField<Integer> MAX_PAYLOAD_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxPayloadInMB").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::maxPayloadInMB)).setter(ClarifyInferenceConfig.setter(Builder::maxPayloadInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPayloadInMB").build()}).build();
    private static final SdkField<Integer> PROBABILITY_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProbabilityIndex").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::probabilityIndex)).setter(ClarifyInferenceConfig.setter(Builder::probabilityIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProbabilityIndex").build()}).build();
    private static final SdkField<Integer> LABEL_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LabelIndex").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::labelIndex)).setter(ClarifyInferenceConfig.setter(Builder::labelIndex)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelIndex").build()}).build();
    private static final SdkField<String> PROBABILITY_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProbabilityAttribute").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::probabilityAttribute)).setter(ClarifyInferenceConfig.setter(Builder::probabilityAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProbabilityAttribute").build()}).build();
    private static final SdkField<String> LABEL_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelAttribute").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::labelAttribute)).setter(ClarifyInferenceConfig.setter(Builder::labelAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelAttribute").build()}).build();
    private static final SdkField<List<String>> LABEL_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LabelHeaders").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::labelHeaders)).setter(ClarifyInferenceConfig.setter(Builder::labelHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FEATURE_HEADERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureHeaders").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::featureHeaders)).setter(ClarifyInferenceConfig.setter(Builder::featureHeaders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureHeaders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureTypes").getter(ClarifyInferenceConfig.getter(ClarifyInferenceConfig::featureTypesAsStrings)).setter(ClarifyInferenceConfig.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURES_ATTRIBUTE_FIELD, CONTENT_TEMPLATE_FIELD, MAX_RECORD_COUNT_FIELD, MAX_PAYLOAD_IN_MB_FIELD, PROBABILITY_INDEX_FIELD, LABEL_INDEX_FIELD, PROBABILITY_ATTRIBUTE_FIELD, LABEL_ATTRIBUTE_FIELD, LABEL_HEADERS_FIELD, FEATURE_HEADERS_FIELD, FEATURE_TYPES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String featuresAttribute;
    private final String contentTemplate;
    private final Integer maxRecordCount;
    private final Integer maxPayloadInMB;
    private final Integer probabilityIndex;
    private final Integer labelIndex;
    private final String probabilityAttribute;
    private final String labelAttribute;
    private final List<String> labelHeaders;
    private final List<String> featureHeaders;
    private final List<String> featureTypes;

    private ClarifyInferenceConfig(BuilderImpl builder) {
        this.featuresAttribute = builder.featuresAttribute;
        this.contentTemplate = builder.contentTemplate;
        this.maxRecordCount = builder.maxRecordCount;
        this.maxPayloadInMB = builder.maxPayloadInMB;
        this.probabilityIndex = builder.probabilityIndex;
        this.labelIndex = builder.labelIndex;
        this.probabilityAttribute = builder.probabilityAttribute;
        this.labelAttribute = builder.labelAttribute;
        this.labelHeaders = builder.labelHeaders;
        this.featureHeaders = builder.featureHeaders;
        this.featureTypes = builder.featureTypes;
    }

    public final String featuresAttribute() {
        return this.featuresAttribute;
    }

    public final String contentTemplate() {
        return this.contentTemplate;
    }

    public final Integer maxRecordCount() {
        return this.maxRecordCount;
    }

    public final Integer maxPayloadInMB() {
        return this.maxPayloadInMB;
    }

    public final Integer probabilityIndex() {
        return this.probabilityIndex;
    }

    public final Integer labelIndex() {
        return this.labelIndex;
    }

    public final String probabilityAttribute() {
        return this.probabilityAttribute;
    }

    public final String labelAttribute() {
        return this.labelAttribute;
    }

    public final boolean hasLabelHeaders() {
        return this.labelHeaders != null && !(this.labelHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> labelHeaders() {
        return this.labelHeaders;
    }

    public final boolean hasFeatureHeaders() {
        return this.featureHeaders != null && !(this.featureHeaders instanceof SdkAutoConstructList);
    }

    public final List<String> featureHeaders() {
        return this.featureHeaders;
    }

    public final List<ClarifyFeatureType> featureTypes() {
        return ClarifyFeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public final boolean hasFeatureTypes() {
        return this.featureTypes != null && !(this.featureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featuresAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecordCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPayloadInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.probabilityIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.probabilityAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLabelHeaders() ? this.labelHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureHeaders() ? this.featureHeaders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureTypes() ? this.featureTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClarifyInferenceConfig)) {
            return false;
        }
        ClarifyInferenceConfig other = (ClarifyInferenceConfig)obj;
        return Objects.equals(this.featuresAttribute(), other.featuresAttribute()) && Objects.equals(this.contentTemplate(), other.contentTemplate()) && Objects.equals(this.maxRecordCount(), other.maxRecordCount()) && Objects.equals(this.maxPayloadInMB(), other.maxPayloadInMB()) && Objects.equals(this.probabilityIndex(), other.probabilityIndex()) && Objects.equals(this.labelIndex(), other.labelIndex()) && Objects.equals(this.probabilityAttribute(), other.probabilityAttribute()) && Objects.equals(this.labelAttribute(), other.labelAttribute()) && this.hasLabelHeaders() == other.hasLabelHeaders() && Objects.equals(this.labelHeaders(), other.labelHeaders()) && this.hasFeatureHeaders() == other.hasFeatureHeaders() && Objects.equals(this.featureHeaders(), other.featureHeaders()) && this.hasFeatureTypes() == other.hasFeatureTypes() && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ClarifyInferenceConfig").add("FeaturesAttribute", (Object)this.featuresAttribute()).add("ContentTemplate", (Object)this.contentTemplate()).add("MaxRecordCount", (Object)this.maxRecordCount()).add("MaxPayloadInMB", (Object)this.maxPayloadInMB()).add("ProbabilityIndex", (Object)this.probabilityIndex()).add("LabelIndex", (Object)this.labelIndex()).add("ProbabilityAttribute", (Object)this.probabilityAttribute()).add("LabelAttribute", (Object)this.labelAttribute()).add("LabelHeaders", this.hasLabelHeaders() ? this.labelHeaders() : null).add("FeatureHeaders", this.hasFeatureHeaders() ? this.featureHeaders() : null).add("FeatureTypes", this.hasFeatureTypes() ? this.featureTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FeaturesAttribute": {
                return Optional.ofNullable(clazz.cast(this.featuresAttribute()));
            }
            case "ContentTemplate": {
                return Optional.ofNullable(clazz.cast(this.contentTemplate()));
            }
            case "MaxRecordCount": {
                return Optional.ofNullable(clazz.cast(this.maxRecordCount()));
            }
            case "MaxPayloadInMB": {
                return Optional.ofNullable(clazz.cast(this.maxPayloadInMB()));
            }
            case "ProbabilityIndex": {
                return Optional.ofNullable(clazz.cast(this.probabilityIndex()));
            }
            case "LabelIndex": {
                return Optional.ofNullable(clazz.cast(this.labelIndex()));
            }
            case "ProbabilityAttribute": {
                return Optional.ofNullable(clazz.cast(this.probabilityAttribute()));
            }
            case "LabelAttribute": {
                return Optional.ofNullable(clazz.cast(this.labelAttribute()));
            }
            case "LabelHeaders": {
                return Optional.ofNullable(clazz.cast(this.labelHeaders()));
            }
            case "FeatureHeaders": {
                return Optional.ofNullable(clazz.cast(this.featureHeaders()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClarifyInferenceConfig, T> g) {
        return obj -> g.apply((ClarifyInferenceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featuresAttribute;
        private String contentTemplate;
        private Integer maxRecordCount;
        private Integer maxPayloadInMB;
        private Integer probabilityIndex;
        private Integer labelIndex;
        private String probabilityAttribute;
        private String labelAttribute;
        private List<String> labelHeaders = DefaultSdkAutoConstructList.getInstance();
        private List<String> featureHeaders = DefaultSdkAutoConstructList.getInstance();
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClarifyInferenceConfig model) {
            this.featuresAttribute(model.featuresAttribute);
            this.contentTemplate(model.contentTemplate);
            this.maxRecordCount(model.maxRecordCount);
            this.maxPayloadInMB(model.maxPayloadInMB);
            this.probabilityIndex(model.probabilityIndex);
            this.labelIndex(model.labelIndex);
            this.probabilityAttribute(model.probabilityAttribute);
            this.labelAttribute(model.labelAttribute);
            this.labelHeaders(model.labelHeaders);
            this.featureHeaders(model.featureHeaders);
            this.featureTypesWithStrings(model.featureTypes);
        }

        public final String getFeaturesAttribute() {
            return this.featuresAttribute;
        }

        public final void setFeaturesAttribute(String featuresAttribute) {
            this.featuresAttribute = featuresAttribute;
        }

        @Override
        public final Builder featuresAttribute(String featuresAttribute) {
            this.featuresAttribute = featuresAttribute;
            return this;
        }

        public final String getContentTemplate() {
            return this.contentTemplate;
        }

        public final void setContentTemplate(String contentTemplate) {
            this.contentTemplate = contentTemplate;
        }

        @Override
        public final Builder contentTemplate(String contentTemplate) {
            this.contentTemplate = contentTemplate;
            return this;
        }

        public final Integer getMaxRecordCount() {
            return this.maxRecordCount;
        }

        public final void setMaxRecordCount(Integer maxRecordCount) {
            this.maxRecordCount = maxRecordCount;
        }

        @Override
        public final Builder maxRecordCount(Integer maxRecordCount) {
            this.maxRecordCount = maxRecordCount;
            return this;
        }

        public final Integer getMaxPayloadInMB() {
            return this.maxPayloadInMB;
        }

        public final void setMaxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
        }

        @Override
        public final Builder maxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
            return this;
        }

        public final Integer getProbabilityIndex() {
            return this.probabilityIndex;
        }

        public final void setProbabilityIndex(Integer probabilityIndex) {
            this.probabilityIndex = probabilityIndex;
        }

        @Override
        public final Builder probabilityIndex(Integer probabilityIndex) {
            this.probabilityIndex = probabilityIndex;
            return this;
        }

        public final Integer getLabelIndex() {
            return this.labelIndex;
        }

        public final void setLabelIndex(Integer labelIndex) {
            this.labelIndex = labelIndex;
        }

        @Override
        public final Builder labelIndex(Integer labelIndex) {
            this.labelIndex = labelIndex;
            return this;
        }

        public final String getProbabilityAttribute() {
            return this.probabilityAttribute;
        }

        public final void setProbabilityAttribute(String probabilityAttribute) {
            this.probabilityAttribute = probabilityAttribute;
        }

        @Override
        public final Builder probabilityAttribute(String probabilityAttribute) {
            this.probabilityAttribute = probabilityAttribute;
            return this;
        }

        public final String getLabelAttribute() {
            return this.labelAttribute;
        }

        public final void setLabelAttribute(String labelAttribute) {
            this.labelAttribute = labelAttribute;
        }

        @Override
        public final Builder labelAttribute(String labelAttribute) {
            this.labelAttribute = labelAttribute;
            return this;
        }

        public final Collection<String> getLabelHeaders() {
            if (this.labelHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.labelHeaders;
        }

        public final void setLabelHeaders(Collection<String> labelHeaders) {
            this.labelHeaders = ClarifyLabelHeadersCopier.copy(labelHeaders);
        }

        @Override
        public final Builder labelHeaders(Collection<String> labelHeaders) {
            this.labelHeaders = ClarifyLabelHeadersCopier.copy(labelHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder labelHeaders(String ... labelHeaders) {
            this.labelHeaders(Arrays.asList(labelHeaders));
            return this;
        }

        public final Collection<String> getFeatureHeaders() {
            if (this.featureHeaders instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureHeaders;
        }

        public final void setFeatureHeaders(Collection<String> featureHeaders) {
            this.featureHeaders = ClarifyFeatureHeadersCopier.copy(featureHeaders);
        }

        @Override
        public final Builder featureHeaders(Collection<String> featureHeaders) {
            this.featureHeaders = ClarifyFeatureHeadersCopier.copy(featureHeaders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureHeaders(String ... featureHeaders) {
            this.featureHeaders(Arrays.asList(featureHeaders));
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (this.featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = ClarifyFeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = ClarifyFeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<ClarifyFeatureType> featureTypes) {
            this.featureTypes = ClarifyFeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(ClarifyFeatureType ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public ClarifyInferenceConfig build() {
            return new ClarifyInferenceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClarifyInferenceConfig> {
        public Builder featuresAttribute(String var1);

        public Builder contentTemplate(String var1);

        public Builder maxRecordCount(Integer var1);

        public Builder maxPayloadInMB(Integer var1);

        public Builder probabilityIndex(Integer var1);

        public Builder labelIndex(Integer var1);

        public Builder probabilityAttribute(String var1);

        public Builder labelAttribute(String var1);

        public Builder labelHeaders(Collection<String> var1);

        public Builder labelHeaders(String ... var1);

        public Builder featureHeaders(Collection<String> var1);

        public Builder featureHeaders(String ... var1);

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<ClarifyFeatureType> var1);

        public Builder featureTypes(ClarifyFeatureType ... var1);
    }
}

