/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListWorkforcesResponse;
import software.amazon.awssdk.services.sagemaker.model.Workforce;

public class ListWorkforcesIterable
implements SdkIterable<ListWorkforcesResponse> {
    private final SageMakerClient client;
    private final ListWorkforcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkforcesIterable(SageMakerClient client, ListWorkforcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListWorkforcesResponseFetcher();
    }

    public Iterator<ListWorkforcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Workforce> workforces() {
        Function<ListWorkforcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.workforces() != null) {
                return response.workforces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkforcesResponseFetcher
    implements SyncPageFetcher<ListWorkforcesResponse> {
        private ListWorkforcesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkforcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkforcesResponse nextPage(ListWorkforcesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkforcesIterable.this.client.listWorkforces(ListWorkforcesIterable.this.firstRequest);
            }
            return ListWorkforcesIterable.this.client.listWorkforces((ListWorkforcesRequest)((Object)ListWorkforcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

