/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelCardProcessingStatus {
    DELETE_IN_PROGRESS("DeleteInProgress"),
    DELETE_PENDING("DeletePending"),
    CONTENT_DELETED("ContentDeleted"),
    EXPORT_JOBS_DELETED("ExportJobsDeleted"),
    DELETE_COMPLETED("DeleteCompleted"),
    DELETE_FAILED("DeleteFailed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelCardProcessingStatus> VALUE_MAP;
    private final String value;

    private ModelCardProcessingStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelCardProcessingStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelCardProcessingStatus> knownValues() {
        EnumSet<ModelCardProcessingStatus> knownValues = EnumSet.allOf(ModelCardProcessingStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelCardProcessingStatus.class, ModelCardProcessingStatus::toString);
    }
}

