/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter;
import software.amazon.awssdk.services.sagemaker.model.ProvisioningParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceCatalogProvisioningUpdateDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceCatalogProvisioningUpdateDetails> {
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(ServiceCatalogProvisioningUpdateDetails.getter(ServiceCatalogProvisioningUpdateDetails::provisioningArtifactId)).setter(ServiceCatalogProvisioningUpdateDetails.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<List<ProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisioningParameters").getter(ServiceCatalogProvisioningUpdateDetails.getter(ServiceCatalogProvisioningUpdateDetails::provisioningParameters)).setter(ServiceCatalogProvisioningUpdateDetails.setter(Builder::provisioningParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVISIONING_ARTIFACT_ID_FIELD, PROVISIONING_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String provisioningArtifactId;
    private final List<ProvisioningParameter> provisioningParameters;

    private ServiceCatalogProvisioningUpdateDetails(BuilderImpl builder) {
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.provisioningParameters = builder.provisioningParameters;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public final boolean hasProvisioningParameters() {
        return this.provisioningParameters != null && !(this.provisioningParameters instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningParameters() ? this.provisioningParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceCatalogProvisioningUpdateDetails)) {
            return false;
        }
        ServiceCatalogProvisioningUpdateDetails other = (ServiceCatalogProvisioningUpdateDetails)obj;
        return Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && this.hasProvisioningParameters() == other.hasProvisioningParameters() && Objects.equals(this.provisioningParameters(), other.provisioningParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceCatalogProvisioningUpdateDetails").add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("ProvisioningParameters", this.hasProvisioningParameters() ? this.provisioningParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "ProvisioningParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceCatalogProvisioningUpdateDetails, T> g) {
        return obj -> g.apply((ServiceCatalogProvisioningUpdateDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String provisioningArtifactId;
        private List<ProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceCatalogProvisioningUpdateDetails model) {
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.provisioningParameters(model.provisioningParameters);
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final List<ProvisioningParameter.Builder> getProvisioningParameters() {
            List<ProvisioningParameter.Builder> result = ProvisioningParametersCopier.copyToBuilder(this.provisioningParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningParameters(Collection<ProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        @Override
        public final Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(ProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<ProvisioningParameter.Builder> ... provisioningParameters) {
            this.provisioningParameters(Stream.of(provisioningParameters).map(c -> (ProvisioningParameter)((ProvisioningParameter.Builder)ProvisioningParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceCatalogProvisioningUpdateDetails build() {
            return new ServiceCatalogProvisioningUpdateDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceCatalogProvisioningUpdateDetails> {
        public Builder provisioningArtifactId(String var1);

        public Builder provisioningParameters(Collection<ProvisioningParameter> var1);

        public Builder provisioningParameters(ProvisioningParameter ... var1);

        public Builder provisioningParameters(Consumer<ProvisioningParameter.Builder> ... var1);
    }
}

