/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HyperParameterScalingType {
    AUTO("Auto"),
    LINEAR("Linear"),
    LOGARITHMIC("Logarithmic"),
    REVERSE_LOGARITHMIC("ReverseLogarithmic"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HyperParameterScalingType> VALUE_MAP;
    private final String value;

    private HyperParameterScalingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HyperParameterScalingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HyperParameterScalingType> knownValues() {
        EnumSet<HyperParameterScalingType> knownValues = EnumSet.allOf(HyperParameterScalingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HyperParameterScalingType.class, HyperParameterScalingType::toString);
    }
}

