/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringAlertsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary;

public class ListMonitoringAlertsPublisher
implements SdkPublisher<ListMonitoringAlertsResponse> {
    private final SageMakerAsyncClient client;
    private final ListMonitoringAlertsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMonitoringAlertsPublisher(SageMakerAsyncClient client, ListMonitoringAlertsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMonitoringAlertsPublisher(SageMakerAsyncClient client, ListMonitoringAlertsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMonitoringAlertsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMonitoringAlertsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MonitoringAlertSummary> monitoringAlertSummaries() {
        Function<ListMonitoringAlertsResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoringAlertSummaries() != null) {
                return response.monitoringAlertSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMonitoringAlertsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMonitoringAlertsResponseFetcher
    implements AsyncPageFetcher<ListMonitoringAlertsResponse> {
        private ListMonitoringAlertsResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoringAlertsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMonitoringAlertsResponse> nextPage(ListMonitoringAlertsResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoringAlertsPublisher.this.client.listMonitoringAlerts(ListMonitoringAlertsPublisher.this.firstRequest);
            }
            return ListMonitoringAlertsPublisher.this.client.listMonitoringAlerts((ListMonitoringAlertsRequest)((Object)ListMonitoringAlertsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

