/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.InferenceRecommendationsJobStep;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceRecommendationsJobStepsResponse;

public class ListInferenceRecommendationsJobStepsPublisher
implements SdkPublisher<ListInferenceRecommendationsJobStepsResponse> {
    private final SageMakerAsyncClient client;
    private final ListInferenceRecommendationsJobStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInferenceRecommendationsJobStepsPublisher(SageMakerAsyncClient client, ListInferenceRecommendationsJobStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInferenceRecommendationsJobStepsPublisher(SageMakerAsyncClient client, ListInferenceRecommendationsJobStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInferenceRecommendationsJobStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInferenceRecommendationsJobStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InferenceRecommendationsJobStep> steps() {
        Function<ListInferenceRecommendationsJobStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInferenceRecommendationsJobStepsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInferenceRecommendationsJobStepsResponseFetcher
    implements AsyncPageFetcher<ListInferenceRecommendationsJobStepsResponse> {
        private ListInferenceRecommendationsJobStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceRecommendationsJobStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInferenceRecommendationsJobStepsResponse> nextPage(ListInferenceRecommendationsJobStepsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceRecommendationsJobStepsPublisher.this.client.listInferenceRecommendationsJobSteps(ListInferenceRecommendationsJobStepsPublisher.this.firstRequest);
            }
            return ListInferenceRecommendationsJobStepsPublisher.this.client.listInferenceRecommendationsJobSteps((ListInferenceRecommendationsJobStepsRequest)((Object)ListInferenceRecommendationsJobStepsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

