/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AppNetworkAccessType {
    PUBLIC_INTERNET_ONLY("PublicInternetOnly"),
    VPC_ONLY("VpcOnly"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AppNetworkAccessType> VALUE_MAP;
    private final String value;

    private AppNetworkAccessType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AppNetworkAccessType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AppNetworkAccessType> knownValues() {
        EnumSet<AppNetworkAccessType> knownValues = EnumSet.allOf(AppNetworkAccessType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AppNetworkAccessType.class, AppNetworkAccessType::toString);
    }
}

