/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TrialSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrialSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrialSummary> {
    private static final SdkField<String> TRIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialArn").getter(TrialSummary.getter(TrialSummary::trialArn)).setter(TrialSummary.setter(Builder::trialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialArn").build()}).build();
    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialName").getter(TrialSummary.getter(TrialSummary::trialName)).setter(TrialSummary.setter(Builder::trialName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayName").getter(TrialSummary.getter(TrialSummary::displayName)).setter(TrialSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<TrialSource> TRIAL_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrialSource").getter(TrialSummary.getter(TrialSummary::trialSource)).setter(TrialSummary.setter(Builder::trialSource)).constructor(TrialSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialSource").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TrialSummary.getter(TrialSummary::creationTime)).setter(TrialSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(TrialSummary.getter(TrialSummary::lastModifiedTime)).setter(TrialSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_ARN_FIELD, TRIAL_NAME_FIELD, DISPLAY_NAME_FIELD, TRIAL_SOURCE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trialArn;
    private final String trialName;
    private final String displayName;
    private final TrialSource trialSource;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private TrialSummary(BuilderImpl builder) {
        this.trialArn = builder.trialArn;
        this.trialName = builder.trialName;
        this.displayName = builder.displayName;
        this.trialSource = builder.trialSource;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String trialArn() {
        return this.trialArn;
    }

    public final String trialName() {
        return this.trialName;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final TrialSource trialSource() {
        return this.trialSource;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trialArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialName());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialSummary)) {
            return false;
        }
        TrialSummary other = (TrialSummary)obj;
        return Objects.equals(this.trialArn(), other.trialArn()) && Objects.equals(this.trialName(), other.trialName()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.trialSource(), other.trialSource()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"TrialSummary").add("TrialArn", (Object)this.trialArn()).add("TrialName", (Object)this.trialName()).add("DisplayName", (Object)this.displayName()).add("TrialSource", (Object)this.trialSource()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialArn": {
                return Optional.ofNullable(clazz.cast(this.trialArn()));
            }
            case "TrialName": {
                return Optional.ofNullable(clazz.cast(this.trialName()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "TrialSource": {
                return Optional.ofNullable(clazz.cast(this.trialSource()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialSummary, T> g) {
        return obj -> g.apply((TrialSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trialArn;
        private String trialName;
        private String displayName;
        private TrialSource trialSource;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialSummary model) {
            this.trialArn(model.trialArn);
            this.trialName(model.trialName);
            this.displayName(model.displayName);
            this.trialSource(model.trialSource);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getTrialArn() {
            return this.trialArn;
        }

        public final void setTrialArn(String trialArn) {
            this.trialArn = trialArn;
        }

        @Override
        @Transient
        public final Builder trialArn(String trialArn) {
            this.trialArn = trialArn;
            return this;
        }

        public final String getTrialName() {
            return this.trialName;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        @Override
        @Transient
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Transient
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final TrialSource.Builder getTrialSource() {
            return this.trialSource != null ? this.trialSource.toBuilder() : null;
        }

        public final void setTrialSource(TrialSource.BuilderImpl trialSource) {
            this.trialSource = trialSource != null ? trialSource.build() : null;
        }

        @Override
        @Transient
        public final Builder trialSource(TrialSource trialSource) {
            this.trialSource = trialSource;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public TrialSummary build() {
            return new TrialSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrialSummary> {
        public Builder trialArn(String var1);

        public Builder trialName(String var1);

        public Builder displayName(String var1);

        public Builder trialSource(TrialSource var1);

        default public Builder trialSource(Consumer<TrialSource.Builder> trialSource) {
            return this.trialSource((TrialSource)((TrialSource.Builder)TrialSource.builder().applyMutation(trialSource)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

