/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParameterType {
    INTEGER("Integer"),
    CONTINUOUS("Continuous"),
    CATEGORICAL("Categorical"),
    FREE_TEXT("FreeText"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParameterType> VALUE_MAP;
    private final String value;

    private ParameterType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParameterType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParameterType> knownValues() {
        EnumSet<ParameterType> knownValues = EnumSet.allOf(ParameterType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParameterType.class, ParameterType::toString);
    }
}

