/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TargetDevice;
import software.amazon.awssdk.services.sagemaker.model.TargetPlatform;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputConfig> {
    private static final SdkField<String> S3_OUTPUT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputLocation").getter(OutputConfig.getter(OutputConfig::s3OutputLocation)).setter(OutputConfig.setter(Builder::s3OutputLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputLocation").build()}).build();
    private static final SdkField<String> TARGET_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetDevice").getter(OutputConfig.getter(OutputConfig::targetDeviceAsString)).setter(OutputConfig.setter(Builder::targetDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetDevice").build()}).build();
    private static final SdkField<TargetPlatform> TARGET_PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetPlatform").getter(OutputConfig.getter(OutputConfig::targetPlatform)).setter(OutputConfig.setter(Builder::targetPlatform)).constructor(TargetPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetPlatform").build()}).build();
    private static final SdkField<String> COMPILER_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompilerOptions").getter(OutputConfig.getter(OutputConfig::compilerOptions)).setter(OutputConfig.setter(Builder::compilerOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilerOptions").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(OutputConfig.getter(OutputConfig::kmsKeyId)).setter(OutputConfig.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_LOCATION_FIELD, TARGET_DEVICE_FIELD, TARGET_PLATFORM_FIELD, COMPILER_OPTIONS_FIELD, KMS_KEY_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3OutputLocation;
    private final String targetDevice;
    private final TargetPlatform targetPlatform;
    private final String compilerOptions;
    private final String kmsKeyId;

    private OutputConfig(BuilderImpl builder) {
        this.s3OutputLocation = builder.s3OutputLocation;
        this.targetDevice = builder.targetDevice;
        this.targetPlatform = builder.targetPlatform;
        this.compilerOptions = builder.compilerOptions;
        this.kmsKeyId = builder.kmsKeyId;
    }

    public final String s3OutputLocation() {
        return this.s3OutputLocation;
    }

    public final TargetDevice targetDevice() {
        return TargetDevice.fromValue(this.targetDevice);
    }

    public final String targetDeviceAsString() {
        return this.targetDevice;
    }

    public final TargetPlatform targetPlatform() {
        return this.targetPlatform;
    }

    public final String compilerOptions() {
        return this.compilerOptions;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetDeviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(this.compilerOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputConfig)) {
            return false;
        }
        OutputConfig other = (OutputConfig)obj;
        return Objects.equals(this.s3OutputLocation(), other.s3OutputLocation()) && Objects.equals(this.targetDeviceAsString(), other.targetDeviceAsString()) && Objects.equals(this.targetPlatform(), other.targetPlatform()) && Objects.equals(this.compilerOptions(), other.compilerOptions()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId());
    }

    public final String toString() {
        return ToString.builder((String)"OutputConfig").add("S3OutputLocation", (Object)this.s3OutputLocation()).add("TargetDevice", (Object)this.targetDeviceAsString()).add("TargetPlatform", (Object)this.targetPlatform()).add("CompilerOptions", (Object)this.compilerOptions()).add("KmsKeyId", (Object)this.kmsKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputLocation": {
                return Optional.ofNullable(clazz.cast(this.s3OutputLocation()));
            }
            case "TargetDevice": {
                return Optional.ofNullable(clazz.cast(this.targetDeviceAsString()));
            }
            case "TargetPlatform": {
                return Optional.ofNullable(clazz.cast(this.targetPlatform()));
            }
            case "CompilerOptions": {
                return Optional.ofNullable(clazz.cast(this.compilerOptions()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputConfig, T> g) {
        return obj -> g.apply((OutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3OutputLocation;
        private String targetDevice;
        private TargetPlatform targetPlatform;
        private String compilerOptions;
        private String kmsKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputConfig model) {
            this.s3OutputLocation(model.s3OutputLocation);
            this.targetDevice(model.targetDevice);
            this.targetPlatform(model.targetPlatform);
            this.compilerOptions(model.compilerOptions);
            this.kmsKeyId(model.kmsKeyId);
        }

        public final String getS3OutputLocation() {
            return this.s3OutputLocation;
        }

        public final void setS3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
        }

        @Override
        @Transient
        public final Builder s3OutputLocation(String s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public final String getTargetDevice() {
            return this.targetDevice;
        }

        public final void setTargetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
        }

        @Override
        @Transient
        public final Builder targetDevice(String targetDevice) {
            this.targetDevice = targetDevice;
            return this;
        }

        @Override
        @Transient
        public final Builder targetDevice(TargetDevice targetDevice) {
            this.targetDevice(targetDevice == null ? null : targetDevice.toString());
            return this;
        }

        public final TargetPlatform.Builder getTargetPlatform() {
            return this.targetPlatform != null ? this.targetPlatform.toBuilder() : null;
        }

        public final void setTargetPlatform(TargetPlatform.BuilderImpl targetPlatform) {
            this.targetPlatform = targetPlatform != null ? targetPlatform.build() : null;
        }

        @Override
        @Transient
        public final Builder targetPlatform(TargetPlatform targetPlatform) {
            this.targetPlatform = targetPlatform;
            return this;
        }

        public final String getCompilerOptions() {
            return this.compilerOptions;
        }

        public final void setCompilerOptions(String compilerOptions) {
            this.compilerOptions = compilerOptions;
        }

        @Override
        @Transient
        public final Builder compilerOptions(String compilerOptions) {
            this.compilerOptions = compilerOptions;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public OutputConfig build() {
            return new OutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputConfig> {
        public Builder s3OutputLocation(String var1);

        public Builder targetDevice(String var1);

        public Builder targetDevice(TargetDevice var1);

        public Builder targetPlatform(TargetPlatform var1);

        default public Builder targetPlatform(Consumer<TargetPlatform.Builder> targetPlatform) {
            return this.targetPlatform((TargetPlatform)((TargetPlatform.Builder)TargetPlatform.builder().applyMutation(targetPlatform)).build());
        }

        public Builder compilerOptions(String var1);

        public Builder kmsKeyId(String var1);
    }
}

