/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Parent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Parent> {
    private static final SdkField<String> TRIAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialName").getter(Parent.getter(Parent::trialName)).setter(Parent.setter(Builder::trialName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialName").build()}).build();
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExperimentName").getter(Parent.getter(Parent::experimentName)).setter(Parent.setter(Builder::experimentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_NAME_FIELD, EXPERIMENT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trialName;
    private final String experimentName;

    private Parent(BuilderImpl builder) {
        this.trialName = builder.trialName;
        this.experimentName = builder.experimentName;
    }

    public final String trialName() {
        return this.trialName;
    }

    public final String experimentName() {
        return this.experimentName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trialName());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Parent)) {
            return false;
        }
        Parent other = (Parent)obj;
        return Objects.equals(this.trialName(), other.trialName()) && Objects.equals(this.experimentName(), other.experimentName());
    }

    public final String toString() {
        return ToString.builder((String)"Parent").add("TrialName", (Object)this.trialName()).add("ExperimentName", (Object)this.experimentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrialName": {
                return Optional.ofNullable(clazz.cast(this.trialName()));
            }
            case "ExperimentName": {
                return Optional.ofNullable(clazz.cast(this.experimentName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Parent, T> g) {
        return obj -> g.apply((Parent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trialName;
        private String experimentName;

        private BuilderImpl() {
        }

        private BuilderImpl(Parent model) {
            this.trialName(model.trialName);
            this.experimentName(model.experimentName);
        }

        public final String getTrialName() {
            return this.trialName;
        }

        public final void setTrialName(String trialName) {
            this.trialName = trialName;
        }

        @Override
        @Transient
        public final Builder trialName(String trialName) {
            this.trialName = trialName;
            return this;
        }

        public final String getExperimentName() {
            return this.experimentName;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        @Override
        @Transient
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public Parent build() {
            return new Parent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Parent> {
        public Builder trialName(String var1);

        public Builder experimentName(String var1);
    }
}

