/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ImageVersion;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse;

public class ListImageVersionsPublisher
implements SdkPublisher<ListImageVersionsResponse> {
    private final SageMakerAsyncClient client;
    private final ListImageVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImageVersionsPublisher(SageMakerAsyncClient client, ListImageVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImageVersionsPublisher(SageMakerAsyncClient client, ListImageVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImageVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImageVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageVersion> imageVersions() {
        Function<ListImageVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageVersions() != null) {
                return response.imageVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImageVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImageVersionsResponseFetcher
    implements AsyncPageFetcher<ListImageVersionsResponse> {
        private ListImageVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImageVersionsResponse> nextPage(ListImageVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListImageVersionsPublisher.this.client.listImageVersions(ListImageVersionsPublisher.this.firstRequest);
            }
            return ListImageVersionsPublisher.this.client.listImageVersions((ListImageVersionsRequest)((Object)ListImageVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

