/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMonitoringSchedulesResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleSummary;

public class ListMonitoringSchedulesIterable
implements SdkIterable<ListMonitoringSchedulesResponse> {
    private final SageMakerClient client;
    private final ListMonitoringSchedulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMonitoringSchedulesIterable(SageMakerClient client, ListMonitoringSchedulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMonitoringSchedulesResponseFetcher();
    }

    public Iterator<ListMonitoringSchedulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitoringScheduleSummary> monitoringScheduleSummaries() {
        Function<ListMonitoringSchedulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.monitoringScheduleSummaries() != null) {
                return response.monitoringScheduleSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMonitoringSchedulesResponseFetcher
    implements SyncPageFetcher<ListMonitoringSchedulesResponse> {
        private ListMonitoringSchedulesResponseFetcher() {
        }

        public boolean hasNextPage(ListMonitoringSchedulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMonitoringSchedulesResponse nextPage(ListMonitoringSchedulesResponse previousPage) {
            if (previousPage == null) {
                return ListMonitoringSchedulesIterable.this.client.listMonitoringSchedules(ListMonitoringSchedulesIterable.this.firstRequest);
            }
            return ListMonitoringSchedulesIterable.this.client.listMonitoringSchedules((ListMonitoringSchedulesRequest)((Object)ListMonitoringSchedulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

