/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.DomainSettingsForUpdate;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.UserSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, UpdateDomainRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(UpdateDomainRequest.getter(UpdateDomainRequest::domainId)).setter(UpdateDomainRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<UserSettings> DEFAULT_USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultUserSettings").getter(UpdateDomainRequest.getter(UpdateDomainRequest::defaultUserSettings)).setter(UpdateDomainRequest.setter(Builder::defaultUserSettings)).constructor(UserSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultUserSettings").build()}).build();
    private static final SdkField<DomainSettingsForUpdate> DOMAIN_SETTINGS_FOR_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DomainSettingsForUpdate").getter(UpdateDomainRequest.getter(UpdateDomainRequest::domainSettingsForUpdate)).setter(UpdateDomainRequest.setter(Builder::domainSettingsForUpdate)).constructor(DomainSettingsForUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainSettingsForUpdate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, DEFAULT_USER_SETTINGS_FIELD, DOMAIN_SETTINGS_FOR_UPDATE_FIELD));
    private final String domainId;
    private final UserSettings defaultUserSettings;
    private final DomainSettingsForUpdate domainSettingsForUpdate;

    private UpdateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.defaultUserSettings = builder.defaultUserSettings;
        this.domainSettingsForUpdate = builder.domainSettingsForUpdate;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final UserSettings defaultUserSettings() {
        return this.defaultUserSettings;
    }

    public final DomainSettingsForUpdate domainSettingsForUpdate() {
        return this.domainSettingsForUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultUserSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainSettingsForUpdate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainRequest)) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.defaultUserSettings(), other.defaultUserSettings()) && Objects.equals(this.domainSettingsForUpdate(), other.domainSettingsForUpdate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDomainRequest").add("DomainId", (Object)this.domainId()).add("DefaultUserSettings", (Object)this.defaultUserSettings()).add("DomainSettingsForUpdate", (Object)this.domainSettingsForUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "DefaultUserSettings": {
                return Optional.ofNullable(clazz.cast(this.defaultUserSettings()));
            }
            case "DomainSettingsForUpdate": {
                return Optional.ofNullable(clazz.cast(this.domainSettingsForUpdate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainRequest, T> g) {
        return obj -> g.apply((UpdateDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private UserSettings defaultUserSettings;
        private DomainSettingsForUpdate domainSettingsForUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.defaultUserSettings(model.defaultUserSettings);
            this.domainSettingsForUpdate(model.domainSettingsForUpdate);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final UserSettings.Builder getDefaultUserSettings() {
            return this.defaultUserSettings != null ? this.defaultUserSettings.toBuilder() : null;
        }

        public final void setDefaultUserSettings(UserSettings.BuilderImpl defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings != null ? defaultUserSettings.build() : null;
        }

        @Override
        public final Builder defaultUserSettings(UserSettings defaultUserSettings) {
            this.defaultUserSettings = defaultUserSettings;
            return this;
        }

        public final DomainSettingsForUpdate.Builder getDomainSettingsForUpdate() {
            return this.domainSettingsForUpdate != null ? this.domainSettingsForUpdate.toBuilder() : null;
        }

        public final void setDomainSettingsForUpdate(DomainSettingsForUpdate.BuilderImpl domainSettingsForUpdate) {
            this.domainSettingsForUpdate = domainSettingsForUpdate != null ? domainSettingsForUpdate.build() : null;
        }

        @Override
        public final Builder domainSettingsForUpdate(DomainSettingsForUpdate domainSettingsForUpdate) {
            this.domainSettingsForUpdate = domainSettingsForUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainRequest build() {
            return new UpdateDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainRequest> {
        public Builder domainId(String var1);

        public Builder defaultUserSettings(UserSettings var1);

        default public Builder defaultUserSettings(Consumer<UserSettings.Builder> defaultUserSettings) {
            return this.defaultUserSettings((UserSettings)((UserSettings.Builder)UserSettings.builder().applyMutation(defaultUserSettings)).build());
        }

        public Builder domainSettingsForUpdate(DomainSettingsForUpdate var1);

        default public Builder domainSettingsForUpdate(Consumer<DomainSettingsForUpdate.Builder> domainSettingsForUpdate) {
            return this.domainSettingsForUpdate((DomainSettingsForUpdate)((DomainSettingsForUpdate.Builder)DomainSettingsForUpdate.builder().applyMutation(domainSettingsForUpdate)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

