/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDataQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary;

public class ListDataQualityJobDefinitionsIterable
implements SdkIterable<ListDataQualityJobDefinitionsResponse> {
    private final SageMakerClient client;
    private final ListDataQualityJobDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataQualityJobDefinitionsIterable(SageMakerClient client, ListDataQualityJobDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDataQualityJobDefinitionsResponseFetcher();
    }

    public Iterator<ListDataQualityJobDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitoringJobDefinitionSummary> jobDefinitionSummaries() {
        Function<ListDataQualityJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobDefinitionSummaries() != null) {
                return response.jobDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataQualityJobDefinitionsResponseFetcher
    implements SyncPageFetcher<ListDataQualityJobDefinitionsResponse> {
        private ListDataQualityJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataQualityJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataQualityJobDefinitionsResponse nextPage(ListDataQualityJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListDataQualityJobDefinitionsIterable.this.client.listDataQualityJobDefinitions(ListDataQualityJobDefinitionsIterable.this.firstRequest);
            }
            return ListDataQualityJobDefinitionsIterable.this.client.listDataQualityJobDefinitions((ListDataQualityJobDefinitionsRequest)((Object)ListDataQualityJobDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

