/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContainerMode {
    SINGLE_MODEL("SingleModel"),
    MULTI_MODEL("MultiModel"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContainerMode> VALUE_MAP;
    private final String value;

    private ContainerMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContainerMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContainerMode> knownValues() {
        EnumSet<ContainerMode> knownValues = EnumSet.allOf(ContainerMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContainerMode.class, ContainerMode::toString);
    }
}

