/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelPackageGroupStatus {
    PENDING("Pending"),
    IN_PROGRESS("InProgress"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    DELETING("Deleting"),
    DELETE_FAILED("DeleteFailed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelPackageGroupStatus> VALUE_MAP;
    private final String value;

    private ModelPackageGroupStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelPackageGroupStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelPackageGroupStatus> knownValues() {
        EnumSet<ModelPackageGroupStatus> knownValues = EnumSet.allOf(ModelPackageGroupStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelPackageGroupStatus.class, ModelPackageGroupStatus::toString);
    }
}

