/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListPipelineExecutionStepsResponse;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionStep;

public class ListPipelineExecutionStepsPublisher
implements SdkPublisher<ListPipelineExecutionStepsResponse> {
    private final SageMakerAsyncClient client;
    private final ListPipelineExecutionStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPipelineExecutionStepsPublisher(SageMakerAsyncClient client, ListPipelineExecutionStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPipelineExecutionStepsPublisher(SageMakerAsyncClient client, ListPipelineExecutionStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPipelineExecutionStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPipelineExecutionStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PipelineExecutionStep> pipelineExecutionSteps() {
        Function<ListPipelineExecutionStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.pipelineExecutionSteps() != null) {
                return response.pipelineExecutionSteps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPipelineExecutionStepsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPipelineExecutionStepsResponseFetcher
    implements AsyncPageFetcher<ListPipelineExecutionStepsResponse> {
        private ListPipelineExecutionStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListPipelineExecutionStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPipelineExecutionStepsResponse> nextPage(ListPipelineExecutionStepsResponse previousPage) {
            if (previousPage == null) {
                return ListPipelineExecutionStepsPublisher.this.client.listPipelineExecutionSteps(ListPipelineExecutionStepsPublisher.this.firstRequest);
            }
            return ListPipelineExecutionStepsPublisher.this.client.listPipelineExecutionSteps((ListPipelineExecutionStepsRequest)((Object)ListPipelineExecutionStepsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

