/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelMetadataResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListModelMetadataResponse> {
    private static final SdkField<List<ModelMetadataSummary>> MODEL_METADATA_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ModelMetadataSummaries").getter(ListModelMetadataResponse.getter(ListModelMetadataResponse::modelMetadataSummaries)).setter(ListModelMetadataResponse.setter(Builder::modelMetadataSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetadataSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelMetadataSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelMetadataResponse.getter(ListModelMetadataResponse::nextToken)).setter(ListModelMetadataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_METADATA_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ModelMetadataSummary> modelMetadataSummaries;
    private final String nextToken;

    private ListModelMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.modelMetadataSummaries = builder.modelMetadataSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasModelMetadataSummaries() {
        return this.modelMetadataSummaries != null && !(this.modelMetadataSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelMetadataSummary> modelMetadataSummaries() {
        return this.modelMetadataSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelMetadataSummaries() ? this.modelMetadataSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelMetadataResponse)) {
            return false;
        }
        ListModelMetadataResponse other = (ListModelMetadataResponse)((Object)obj);
        return this.hasModelMetadataSummaries() == other.hasModelMetadataSummaries() && Objects.equals(this.modelMetadataSummaries(), other.modelMetadataSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelMetadataResponse").add("ModelMetadataSummaries", this.hasModelMetadataSummaries() ? this.modelMetadataSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelMetadataSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelMetadataSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelMetadataResponse, T> g) {
        return obj -> g.apply((ListModelMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ModelMetadataSummary> modelMetadataSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelMetadataResponse model) {
            super(model);
            this.modelMetadataSummaries(model.modelMetadataSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ModelMetadataSummary.Builder> getModelMetadataSummaries() {
            List<ModelMetadataSummary.Builder> result = ModelMetadataSummariesCopier.copyToBuilder(this.modelMetadataSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelMetadataSummaries(Collection<ModelMetadataSummary.BuilderImpl> modelMetadataSummaries) {
            this.modelMetadataSummaries = ModelMetadataSummariesCopier.copyFromBuilder(modelMetadataSummaries);
        }

        @Override
        @Transient
        public final Builder modelMetadataSummaries(Collection<ModelMetadataSummary> modelMetadataSummaries) {
            this.modelMetadataSummaries = ModelMetadataSummariesCopier.copy(modelMetadataSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelMetadataSummaries(ModelMetadataSummary ... modelMetadataSummaries) {
            this.modelMetadataSummaries(Arrays.asList(modelMetadataSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder modelMetadataSummaries(Consumer<ModelMetadataSummary.Builder> ... modelMetadataSummaries) {
            this.modelMetadataSummaries(Stream.of(modelMetadataSummaries).map(c -> (ModelMetadataSummary)((ModelMetadataSummary.Builder)ModelMetadataSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelMetadataResponse build() {
            return new ListModelMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelMetadataResponse> {
        public Builder modelMetadataSummaries(Collection<ModelMetadataSummary> var1);

        public Builder modelMetadataSummaries(ModelMetadataSummary ... var1);

        public Builder modelMetadataSummaries(Consumer<ModelMetadataSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

