/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.RStudioServerProAccessStatus;
import software.amazon.awssdk.services.sagemaker.model.RStudioServerProUserGroup;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RStudioServerProAppSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RStudioServerProAppSettings> {
    private static final SdkField<String> ACCESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessStatus").getter(RStudioServerProAppSettings.getter(RStudioServerProAppSettings::accessStatusAsString)).setter(RStudioServerProAppSettings.setter(Builder::accessStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessStatus").build()}).build();
    private static final SdkField<String> USER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserGroup").getter(RStudioServerProAppSettings.getter(RStudioServerProAppSettings::userGroupAsString)).setter(RStudioServerProAppSettings.setter(Builder::userGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_STATUS_FIELD, USER_GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessStatus;
    private final String userGroup;

    private RStudioServerProAppSettings(BuilderImpl builder) {
        this.accessStatus = builder.accessStatus;
        this.userGroup = builder.userGroup;
    }

    public final RStudioServerProAccessStatus accessStatus() {
        return RStudioServerProAccessStatus.fromValue(this.accessStatus);
    }

    public final String accessStatusAsString() {
        return this.accessStatus;
    }

    public final RStudioServerProUserGroup userGroup() {
        return RStudioServerProUserGroup.fromValue(this.userGroup);
    }

    public final String userGroupAsString() {
        return this.userGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userGroupAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RStudioServerProAppSettings)) {
            return false;
        }
        RStudioServerProAppSettings other = (RStudioServerProAppSettings)obj;
        return Objects.equals(this.accessStatusAsString(), other.accessStatusAsString()) && Objects.equals(this.userGroupAsString(), other.userGroupAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RStudioServerProAppSettings").add("AccessStatus", (Object)this.accessStatusAsString()).add("UserGroup", (Object)this.userGroupAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessStatus": {
                return Optional.ofNullable(clazz.cast(this.accessStatusAsString()));
            }
            case "UserGroup": {
                return Optional.ofNullable(clazz.cast(this.userGroupAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RStudioServerProAppSettings, T> g) {
        return obj -> g.apply((RStudioServerProAppSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessStatus;
        private String userGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(RStudioServerProAppSettings model) {
            this.accessStatus(model.accessStatus);
            this.userGroup(model.userGroup);
        }

        public final String getAccessStatus() {
            return this.accessStatus;
        }

        public final void setAccessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
        }

        @Override
        @Transient
        public final Builder accessStatus(String accessStatus) {
            this.accessStatus = accessStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder accessStatus(RStudioServerProAccessStatus accessStatus) {
            this.accessStatus(accessStatus == null ? null : accessStatus.toString());
            return this;
        }

        public final String getUserGroup() {
            return this.userGroup;
        }

        public final void setUserGroup(String userGroup) {
            this.userGroup = userGroup;
        }

        @Override
        @Transient
        public final Builder userGroup(String userGroup) {
            this.userGroup = userGroup;
            return this;
        }

        @Override
        @Transient
        public final Builder userGroup(RStudioServerProUserGroup userGroup) {
            this.userGroup(userGroup == null ? null : userGroup.toString());
            return this;
        }

        public RStudioServerProAppSettings build() {
            return new RStudioServerProAppSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RStudioServerProAppSettings> {
        public Builder accessStatus(String var1);

        public Builder accessStatus(RStudioServerProAccessStatus var1);

        public Builder userGroup(String var1);

        public Builder userGroup(RStudioServerProUserGroup var1);
    }
}

