/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EMRStepMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EMRStepMetadata> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(EMRStepMetadata.getter(EMRStepMetadata::clusterId)).setter(EMRStepMetadata.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> STEP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepId").getter(EMRStepMetadata.getter(EMRStepMetadata::stepId)).setter(EMRStepMetadata.setter(Builder::stepId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepId").build()}).build();
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepName").getter(EMRStepMetadata.getter(EMRStepMetadata::stepName)).setter(EMRStepMetadata.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepName").build()}).build();
    private static final SdkField<String> LOG_FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFilePath").getter(EMRStepMetadata.getter(EMRStepMetadata::logFilePath)).setter(EMRStepMetadata.setter(Builder::logFilePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFilePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, STEP_ID_FIELD, STEP_NAME_FIELD, LOG_FILE_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterId;
    private final String stepId;
    private final String stepName;
    private final String logFilePath;

    private EMRStepMetadata(BuilderImpl builder) {
        this.clusterId = builder.clusterId;
        this.stepId = builder.stepId;
        this.stepName = builder.stepName;
        this.logFilePath = builder.logFilePath;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String stepId() {
        return this.stepId;
    }

    public final String stepName() {
        return this.stepName;
    }

    public final String logFilePath() {
        return this.logFilePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFilePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EMRStepMetadata)) {
            return false;
        }
        EMRStepMetadata other = (EMRStepMetadata)obj;
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.stepId(), other.stepId()) && Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.logFilePath(), other.logFilePath());
    }

    public final String toString() {
        return ToString.builder((String)"EMRStepMetadata").add("ClusterId", (Object)this.clusterId()).add("StepId", (Object)this.stepId()).add("StepName", (Object)this.stepName()).add("LogFilePath", (Object)this.logFilePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "StepId": {
                return Optional.ofNullable(clazz.cast(this.stepId()));
            }
            case "StepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "LogFilePath": {
                return Optional.ofNullable(clazz.cast(this.logFilePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EMRStepMetadata, T> g) {
        return obj -> g.apply((EMRStepMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterId;
        private String stepId;
        private String stepName;
        private String logFilePath;

        private BuilderImpl() {
        }

        private BuilderImpl(EMRStepMetadata model) {
            this.clusterId(model.clusterId);
            this.stepId(model.stepId);
            this.stepName(model.stepName);
            this.logFilePath(model.logFilePath);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        @Transient
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getStepId() {
            return this.stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        @Transient
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getStepName() {
            return this.stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        @Transient
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getLogFilePath() {
            return this.logFilePath;
        }

        public final void setLogFilePath(String logFilePath) {
            this.logFilePath = logFilePath;
        }

        @Override
        @Transient
        public final Builder logFilePath(String logFilePath) {
            this.logFilePath = logFilePath;
            return this;
        }

        public EMRStepMetadata build() {
            return new EMRStepMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EMRStepMetadata> {
        public Builder clusterId(String var1);

        public Builder stepId(String var1);

        public Builder stepName(String var1);

        public Builder logFilePath(String var1);
    }
}

