/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CandidateArtifactLocations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CandidateArtifactLocations> {
    private static final SdkField<String> EXPLAINABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Explainability").getter(CandidateArtifactLocations.getter(CandidateArtifactLocations::explainability)).setter(CandidateArtifactLocations.setter(Builder::explainability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explainability").build()}).build();
    private static final SdkField<String> MODEL_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelInsights").getter(CandidateArtifactLocations.getter(CandidateArtifactLocations::modelInsights)).setter(CandidateArtifactLocations.setter(Builder::modelInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelInsights").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPLAINABILITY_FIELD, MODEL_INSIGHTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String explainability;
    private final String modelInsights;

    private CandidateArtifactLocations(BuilderImpl builder) {
        this.explainability = builder.explainability;
        this.modelInsights = builder.modelInsights;
    }

    public final String explainability() {
        return this.explainability;
    }

    public final String modelInsights() {
        return this.modelInsights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.explainability());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelInsights());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CandidateArtifactLocations)) {
            return false;
        }
        CandidateArtifactLocations other = (CandidateArtifactLocations)obj;
        return Objects.equals(this.explainability(), other.explainability()) && Objects.equals(this.modelInsights(), other.modelInsights());
    }

    public final String toString() {
        return ToString.builder((String)"CandidateArtifactLocations").add("Explainability", (Object)this.explainability()).add("ModelInsights", (Object)this.modelInsights()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Explainability": {
                return Optional.ofNullable(clazz.cast(this.explainability()));
            }
            case "ModelInsights": {
                return Optional.ofNullable(clazz.cast(this.modelInsights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CandidateArtifactLocations, T> g) {
        return obj -> g.apply((CandidateArtifactLocations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String explainability;
        private String modelInsights;

        private BuilderImpl() {
        }

        private BuilderImpl(CandidateArtifactLocations model) {
            this.explainability(model.explainability);
            this.modelInsights(model.modelInsights);
        }

        public final String getExplainability() {
            return this.explainability;
        }

        public final void setExplainability(String explainability) {
            this.explainability = explainability;
        }

        @Override
        @Transient
        public final Builder explainability(String explainability) {
            this.explainability = explainability;
            return this;
        }

        public final String getModelInsights() {
            return this.modelInsights;
        }

        public final void setModelInsights(String modelInsights) {
            this.modelInsights = modelInsights;
        }

        @Override
        @Transient
        public final Builder modelInsights(String modelInsights) {
            this.modelInsights = modelInsights;
            return this;
        }

        public CandidateArtifactLocations build() {
            return new CandidateArtifactLocations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CandidateArtifactLocations> {
        public Builder explainability(String var1);

        public Builder modelInsights(String var1);
    }
}

