/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortBy;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupSortOrder;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus;
import software.amazon.awssdk.services.sagemaker.model.OfflineStoreStatusValue;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFeatureGroupsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListFeatureGroupsRequest> {
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameContains").getter(ListFeatureGroupsRequest.getter(ListFeatureGroupsRequest::nameContains)).setter(ListFeatureGroupsRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()}).build();
    private static final SdkField<String> FEATURE_GROUP_STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FeatureGroupStatusEquals").getter(ListFeatureGroupsRequest.getter(ListFeatureGroupsRequest::featureGroupStatusEqualsAsString)).setter(ListFeatureGroupsRequest.setter(Builder::featureGroupStatusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureGroupStatusEquals").build()}).build();
    private static final SdkField<String> OFFLINE_STORE_STATUS_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfflineStoreStatusEquals").getter(ListFeatureGroupsRequest.getter(ListFeatureGroupsRequest::offlineStoreStatusEqualsAsString)).setter(ListFeatureGroupsRequest.setter(Builder::offlineStoreStatusEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfflineStoreStatusEquals").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeAfter").getter(ListFeatureGroupsRequest.getter(ListFeatureGroupsRequest::creationTimeAfter)).setter(ListFeatureGroupsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTimeBefore").getter(ListFeatureGroupsRequest.getter(ListFeatureGroupsRequest::creationTimeBefore)).setter(ListFeatureGroupsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListFeatureGroupsRequest.getter(ListFeatureGroupsRequest::sortOrderAsString)).setter(ListFeatureGroupsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListFeatureGroupsRequest.getter(ListFeatureGroupsRequest::sortByAsString)).setter(ListFeatureGroupsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListFeatureGroupsRequest.getter(ListFeatureGroupsRequest::maxResults)).setter(ListFeatureGroupsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFeatureGroupsRequest.getter(ListFeatureGroupsRequest::nextToken)).setter(ListFeatureGroupsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_CONTAINS_FIELD, FEATURE_GROUP_STATUS_EQUALS_FIELD, OFFLINE_STORE_STATUS_EQUALS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, SORT_ORDER_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String nameContains;
    private final String featureGroupStatusEquals;
    private final String offlineStoreStatusEquals;
    private final Instant creationTimeAfter;
    private final Instant creationTimeBefore;
    private final String sortOrder;
    private final String sortBy;
    private final Integer maxResults;
    private final String nextToken;

    private ListFeatureGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.nameContains = builder.nameContains;
        this.featureGroupStatusEquals = builder.featureGroupStatusEquals;
        this.offlineStoreStatusEquals = builder.offlineStoreStatusEquals;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.sortOrder = builder.sortOrder;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String nameContains() {
        return this.nameContains;
    }

    public final FeatureGroupStatus featureGroupStatusEquals() {
        return FeatureGroupStatus.fromValue(this.featureGroupStatusEquals);
    }

    public final String featureGroupStatusEqualsAsString() {
        return this.featureGroupStatusEquals;
    }

    public final OfflineStoreStatusValue offlineStoreStatusEquals() {
        return OfflineStoreStatusValue.fromValue(this.offlineStoreStatusEquals);
    }

    public final String offlineStoreStatusEqualsAsString() {
        return this.offlineStoreStatusEquals;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final FeatureGroupSortOrder sortOrder() {
        return FeatureGroupSortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final FeatureGroupSortBy sortBy() {
        return FeatureGroupSortBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureGroupStatusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.offlineStoreStatusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFeatureGroupsRequest)) {
            return false;
        }
        ListFeatureGroupsRequest other = (ListFeatureGroupsRequest)((Object)obj);
        return Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.featureGroupStatusEqualsAsString(), other.featureGroupStatusEqualsAsString()) && Objects.equals(this.offlineStoreStatusEqualsAsString(), other.offlineStoreStatusEqualsAsString()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListFeatureGroupsRequest").add("NameContains", (Object)this.nameContains()).add("FeatureGroupStatusEquals", (Object)this.featureGroupStatusEqualsAsString()).add("OfflineStoreStatusEquals", (Object)this.offlineStoreStatusEqualsAsString()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("SortOrder", (Object)this.sortOrderAsString()).add("SortBy", (Object)this.sortByAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "FeatureGroupStatusEquals": {
                return Optional.ofNullable(clazz.cast(this.featureGroupStatusEqualsAsString()));
            }
            case "OfflineStoreStatusEquals": {
                return Optional.ofNullable(clazz.cast(this.offlineStoreStatusEqualsAsString()));
            }
            case "CreationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "CreationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFeatureGroupsRequest, T> g) {
        return obj -> g.apply((ListFeatureGroupsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String nameContains;
        private String featureGroupStatusEquals;
        private String offlineStoreStatusEquals;
        private Instant creationTimeAfter;
        private Instant creationTimeBefore;
        private String sortOrder;
        private String sortBy;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFeatureGroupsRequest model) {
            super(model);
            this.nameContains(model.nameContains);
            this.featureGroupStatusEquals(model.featureGroupStatusEquals);
            this.offlineStoreStatusEquals(model.offlineStoreStatusEquals);
            this.creationTimeAfter(model.creationTimeAfter);
            this.creationTimeBefore(model.creationTimeBefore);
            this.sortOrder(model.sortOrder);
            this.sortBy(model.sortBy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        @Transient
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getFeatureGroupStatusEquals() {
            return this.featureGroupStatusEquals;
        }

        public final void setFeatureGroupStatusEquals(String featureGroupStatusEquals) {
            this.featureGroupStatusEquals = featureGroupStatusEquals;
        }

        @Override
        @Transient
        public final Builder featureGroupStatusEquals(String featureGroupStatusEquals) {
            this.featureGroupStatusEquals = featureGroupStatusEquals;
            return this;
        }

        @Override
        @Transient
        public final Builder featureGroupStatusEquals(FeatureGroupStatus featureGroupStatusEquals) {
            this.featureGroupStatusEquals(featureGroupStatusEquals == null ? null : featureGroupStatusEquals.toString());
            return this;
        }

        public final String getOfflineStoreStatusEquals() {
            return this.offlineStoreStatusEquals;
        }

        public final void setOfflineStoreStatusEquals(String offlineStoreStatusEquals) {
            this.offlineStoreStatusEquals = offlineStoreStatusEquals;
        }

        @Override
        @Transient
        public final Builder offlineStoreStatusEquals(String offlineStoreStatusEquals) {
            this.offlineStoreStatusEquals = offlineStoreStatusEquals;
            return this;
        }

        @Override
        @Transient
        public final Builder offlineStoreStatusEquals(OfflineStoreStatusValue offlineStoreStatusEquals) {
            this.offlineStoreStatusEquals(offlineStoreStatusEquals == null ? null : offlineStoreStatusEquals.toString());
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        @Transient
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        @Transient
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        @Transient
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        @Transient
        public final Builder sortOrder(FeatureGroupSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        @Transient
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        @Transient
        public final Builder sortBy(FeatureGroupSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFeatureGroupsRequest build() {
            return new ListFeatureGroupsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFeatureGroupsRequest> {
        public Builder nameContains(String var1);

        public Builder featureGroupStatusEquals(String var1);

        public Builder featureGroupStatusEquals(FeatureGroupStatus var1);

        public Builder offlineStoreStatusEquals(String var1);

        public Builder offlineStoreStatusEquals(OfflineStoreStatusValue var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder creationTimeBefore(Instant var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(FeatureGroupSortOrder var1);

        public Builder sortBy(String var1);

        public Builder sortBy(FeatureGroupSortBy var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

