/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.FileSource;
import software.amazon.awssdk.services.sagemaker.model.MetricsSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DriftCheckBias
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DriftCheckBias> {
    private static final SdkField<FileSource> CONFIG_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigFile").getter(DriftCheckBias.getter(DriftCheckBias::configFile)).setter(DriftCheckBias.setter(Builder::configFile)).constructor(FileSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigFile").build()}).build();
    private static final SdkField<MetricsSource> PRE_TRAINING_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreTrainingConstraints").getter(DriftCheckBias.getter(DriftCheckBias::preTrainingConstraints)).setter(DriftCheckBias.setter(Builder::preTrainingConstraints)).constructor(MetricsSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreTrainingConstraints").build()}).build();
    private static final SdkField<MetricsSource> POST_TRAINING_CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PostTrainingConstraints").getter(DriftCheckBias.getter(DriftCheckBias::postTrainingConstraints)).setter(DriftCheckBias.setter(Builder::postTrainingConstraints)).constructor(MetricsSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostTrainingConstraints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_FILE_FIELD, PRE_TRAINING_CONSTRAINTS_FIELD, POST_TRAINING_CONSTRAINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final FileSource configFile;
    private final MetricsSource preTrainingConstraints;
    private final MetricsSource postTrainingConstraints;

    private DriftCheckBias(BuilderImpl builder) {
        this.configFile = builder.configFile;
        this.preTrainingConstraints = builder.preTrainingConstraints;
        this.postTrainingConstraints = builder.postTrainingConstraints;
    }

    public final FileSource configFile() {
        return this.configFile;
    }

    public final MetricsSource preTrainingConstraints() {
        return this.preTrainingConstraints;
    }

    public final MetricsSource postTrainingConstraints() {
        return this.postTrainingConstraints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.configFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.preTrainingConstraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.postTrainingConstraints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DriftCheckBias)) {
            return false;
        }
        DriftCheckBias other = (DriftCheckBias)obj;
        return Objects.equals(this.configFile(), other.configFile()) && Objects.equals(this.preTrainingConstraints(), other.preTrainingConstraints()) && Objects.equals(this.postTrainingConstraints(), other.postTrainingConstraints());
    }

    public final String toString() {
        return ToString.builder((String)"DriftCheckBias").add("ConfigFile", (Object)this.configFile()).add("PreTrainingConstraints", (Object)this.preTrainingConstraints()).add("PostTrainingConstraints", (Object)this.postTrainingConstraints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigFile": {
                return Optional.ofNullable(clazz.cast(this.configFile()));
            }
            case "PreTrainingConstraints": {
                return Optional.ofNullable(clazz.cast(this.preTrainingConstraints()));
            }
            case "PostTrainingConstraints": {
                return Optional.ofNullable(clazz.cast(this.postTrainingConstraints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DriftCheckBias, T> g) {
        return obj -> g.apply((DriftCheckBias)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FileSource configFile;
        private MetricsSource preTrainingConstraints;
        private MetricsSource postTrainingConstraints;

        private BuilderImpl() {
        }

        private BuilderImpl(DriftCheckBias model) {
            this.configFile(model.configFile);
            this.preTrainingConstraints(model.preTrainingConstraints);
            this.postTrainingConstraints(model.postTrainingConstraints);
        }

        public final FileSource.Builder getConfigFile() {
            return this.configFile != null ? this.configFile.toBuilder() : null;
        }

        public final void setConfigFile(FileSource.BuilderImpl configFile) {
            this.configFile = configFile != null ? configFile.build() : null;
        }

        @Override
        @Transient
        public final Builder configFile(FileSource configFile) {
            this.configFile = configFile;
            return this;
        }

        public final MetricsSource.Builder getPreTrainingConstraints() {
            return this.preTrainingConstraints != null ? this.preTrainingConstraints.toBuilder() : null;
        }

        public final void setPreTrainingConstraints(MetricsSource.BuilderImpl preTrainingConstraints) {
            this.preTrainingConstraints = preTrainingConstraints != null ? preTrainingConstraints.build() : null;
        }

        @Override
        @Transient
        public final Builder preTrainingConstraints(MetricsSource preTrainingConstraints) {
            this.preTrainingConstraints = preTrainingConstraints;
            return this;
        }

        public final MetricsSource.Builder getPostTrainingConstraints() {
            return this.postTrainingConstraints != null ? this.postTrainingConstraints.toBuilder() : null;
        }

        public final void setPostTrainingConstraints(MetricsSource.BuilderImpl postTrainingConstraints) {
            this.postTrainingConstraints = postTrainingConstraints != null ? postTrainingConstraints.build() : null;
        }

        @Override
        @Transient
        public final Builder postTrainingConstraints(MetricsSource postTrainingConstraints) {
            this.postTrainingConstraints = postTrainingConstraints;
            return this;
        }

        public DriftCheckBias build() {
            return new DriftCheckBias(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DriftCheckBias> {
        public Builder configFile(FileSource var1);

        default public Builder configFile(Consumer<FileSource.Builder> configFile) {
            return this.configFile((FileSource)((FileSource.Builder)FileSource.builder().applyMutation(configFile)).build());
        }

        public Builder preTrainingConstraints(MetricsSource var1);

        default public Builder preTrainingConstraints(Consumer<MetricsSource.Builder> preTrainingConstraints) {
            return this.preTrainingConstraints((MetricsSource)((MetricsSource.Builder)MetricsSource.builder().applyMutation(preTrainingConstraints)).build());
        }

        public Builder postTrainingConstraints(MetricsSource var1);

        default public Builder postTrainingConstraints(Consumer<MetricsSource.Builder> postTrainingConstraints) {
            return this.postTrainingConstraints((MetricsSource)((MetricsSource.Builder)MetricsSource.builder().applyMutation(postTrainingConstraints)).build());
        }
    }
}

