/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.DataCaptureConfigSummary;
import software.amazon.awssdk.services.sagemaker.model.EndpointStatus;
import software.amazon.awssdk.services.sagemaker.model.MonitoringSchedule;
import software.amazon.awssdk.services.sagemaker.model.MonitoringScheduleListCopier;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummary;
import software.amazon.awssdk.services.sagemaker.model.ProductionVariantSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Endpoint
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Endpoint> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(Endpoint.getter(Endpoint::endpointName)).setter(Endpoint.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointArn").getter(Endpoint.getter(Endpoint::endpointArn)).setter(Endpoint.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()}).build();
    private static final SdkField<String> ENDPOINT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointConfigName").getter(Endpoint.getter(Endpoint::endpointConfigName)).setter(Endpoint.setter(Builder::endpointConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfigName").build()}).build();
    private static final SdkField<List<ProductionVariantSummary>> PRODUCTION_VARIANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProductionVariants").getter(Endpoint.getter(Endpoint::productionVariants)).setter(Endpoint.setter(Builder::productionVariants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductionVariants").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProductionVariantSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DataCaptureConfigSummary> DATA_CAPTURE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCaptureConfig").getter(Endpoint.getter(Endpoint::dataCaptureConfig)).setter(Endpoint.setter(Builder::dataCaptureConfig)).constructor(DataCaptureConfigSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCaptureConfig").build()}).build();
    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointStatus").getter(Endpoint.getter(Endpoint::endpointStatusAsString)).setter(Endpoint.setter(Builder::endpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(Endpoint.getter(Endpoint::failureReason)).setter(Endpoint.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(Endpoint.getter(Endpoint::creationTime)).setter(Endpoint.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(Endpoint.getter(Endpoint::lastModifiedTime)).setter(Endpoint.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<List<MonitoringSchedule>> MONITORING_SCHEDULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MonitoringSchedules").getter(Endpoint.getter(Endpoint::monitoringSchedules)).setter(Endpoint.setter(Builder::monitoringSchedules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringSchedules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MonitoringSchedule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Endpoint.getter(Endpoint::tags)).setter(Endpoint.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD, ENDPOINT_ARN_FIELD, ENDPOINT_CONFIG_NAME_FIELD, PRODUCTION_VARIANTS_FIELD, DATA_CAPTURE_CONFIG_FIELD, ENDPOINT_STATUS_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MONITORING_SCHEDULES_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String endpointName;
    private final String endpointArn;
    private final String endpointConfigName;
    private final List<ProductionVariantSummary> productionVariants;
    private final DataCaptureConfigSummary dataCaptureConfig;
    private final String endpointStatus;
    private final String failureReason;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final List<MonitoringSchedule> monitoringSchedules;
    private final List<Tag> tags;

    private Endpoint(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.endpointArn = builder.endpointArn;
        this.endpointConfigName = builder.endpointConfigName;
        this.productionVariants = builder.productionVariants;
        this.dataCaptureConfig = builder.dataCaptureConfig;
        this.endpointStatus = builder.endpointStatus;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringSchedules = builder.monitoringSchedules;
        this.tags = builder.tags;
    }

    public final String endpointName() {
        return this.endpointName;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final String endpointConfigName() {
        return this.endpointConfigName;
    }

    public final boolean hasProductionVariants() {
        return this.productionVariants != null && !(this.productionVariants instanceof SdkAutoConstructList);
    }

    public final List<ProductionVariantSummary> productionVariants() {
        return this.productionVariants;
    }

    public final DataCaptureConfigSummary dataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public final EndpointStatus endpointStatus() {
        return EndpointStatus.fromValue(this.endpointStatus);
    }

    public final String endpointStatusAsString() {
        return this.endpointStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final boolean hasMonitoringSchedules() {
        return this.monitoringSchedules != null && !(this.monitoringSchedules instanceof SdkAutoConstructList);
    }

    public final List<MonitoringSchedule> monitoringSchedules() {
        return this.monitoringSchedules;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProductionVariants() ? this.productionVariants() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCaptureConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMonitoringSchedules() ? this.monitoringSchedules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Endpoint)) {
            return false;
        }
        Endpoint other = (Endpoint)obj;
        return Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.endpointConfigName(), other.endpointConfigName()) && this.hasProductionVariants() == other.hasProductionVariants() && Objects.equals(this.productionVariants(), other.productionVariants()) && Objects.equals(this.dataCaptureConfig(), other.dataCaptureConfig()) && Objects.equals(this.endpointStatusAsString(), other.endpointStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && this.hasMonitoringSchedules() == other.hasMonitoringSchedules() && Objects.equals(this.monitoringSchedules(), other.monitoringSchedules()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Endpoint").add("EndpointName", (Object)this.endpointName()).add("EndpointArn", (Object)this.endpointArn()).add("EndpointConfigName", (Object)this.endpointConfigName()).add("ProductionVariants", this.hasProductionVariants() ? this.productionVariants() : null).add("DataCaptureConfig", (Object)this.dataCaptureConfig()).add("EndpointStatus", (Object)this.endpointStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("MonitoringSchedules", this.hasMonitoringSchedules() ? this.monitoringSchedules() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "EndpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "EndpointConfigName": {
                return Optional.ofNullable(clazz.cast(this.endpointConfigName()));
            }
            case "ProductionVariants": {
                return Optional.ofNullable(clazz.cast(this.productionVariants()));
            }
            case "DataCaptureConfig": {
                return Optional.ofNullable(clazz.cast(this.dataCaptureConfig()));
            }
            case "EndpointStatus": {
                return Optional.ofNullable(clazz.cast(this.endpointStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "MonitoringSchedules": {
                return Optional.ofNullable(clazz.cast(this.monitoringSchedules()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Endpoint, T> g) {
        return obj -> g.apply((Endpoint)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointName;
        private String endpointArn;
        private String endpointConfigName;
        private List<ProductionVariantSummary> productionVariants = DefaultSdkAutoConstructList.getInstance();
        private DataCaptureConfigSummary dataCaptureConfig;
        private String endpointStatus;
        private String failureReason;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private List<MonitoringSchedule> monitoringSchedules = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Endpoint model) {
            this.endpointName(model.endpointName);
            this.endpointArn(model.endpointArn);
            this.endpointConfigName(model.endpointConfigName);
            this.productionVariants(model.productionVariants);
            this.dataCaptureConfig(model.dataCaptureConfig);
            this.endpointStatus(model.endpointStatus);
            this.failureReason(model.failureReason);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.monitoringSchedules(model.monitoringSchedules);
            this.tags(model.tags);
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        @Transient
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        @Transient
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getEndpointConfigName() {
            return this.endpointConfigName;
        }

        public final void setEndpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
        }

        @Override
        @Transient
        public final Builder endpointConfigName(String endpointConfigName) {
            this.endpointConfigName = endpointConfigName;
            return this;
        }

        public final List<ProductionVariantSummary.Builder> getProductionVariants() {
            List<ProductionVariantSummary.Builder> result = ProductionVariantSummaryListCopier.copyToBuilder(this.productionVariants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProductionVariants(Collection<ProductionVariantSummary.BuilderImpl> productionVariants) {
            this.productionVariants = ProductionVariantSummaryListCopier.copyFromBuilder(productionVariants);
        }

        @Override
        @Transient
        public final Builder productionVariants(Collection<ProductionVariantSummary> productionVariants) {
            this.productionVariants = ProductionVariantSummaryListCopier.copy(productionVariants);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productionVariants(ProductionVariantSummary ... productionVariants) {
            this.productionVariants(Arrays.asList(productionVariants));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder productionVariants(Consumer<ProductionVariantSummary.Builder> ... productionVariants) {
            this.productionVariants(Stream.of(productionVariants).map(c -> (ProductionVariantSummary)((ProductionVariantSummary.Builder)ProductionVariantSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final DataCaptureConfigSummary.Builder getDataCaptureConfig() {
            return this.dataCaptureConfig != null ? this.dataCaptureConfig.toBuilder() : null;
        }

        public final void setDataCaptureConfig(DataCaptureConfigSummary.BuilderImpl dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig != null ? dataCaptureConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder dataCaptureConfig(DataCaptureConfigSummary dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        public final String getEndpointStatus() {
            return this.endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        @Transient
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder endpointStatus(EndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus == null ? null : endpointStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        @Transient
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        @Transient
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<MonitoringSchedule.Builder> getMonitoringSchedules() {
            List<MonitoringSchedule.Builder> result = MonitoringScheduleListCopier.copyToBuilder(this.monitoringSchedules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringSchedules(Collection<MonitoringSchedule.BuilderImpl> monitoringSchedules) {
            this.monitoringSchedules = MonitoringScheduleListCopier.copyFromBuilder(monitoringSchedules);
        }

        @Override
        @Transient
        public final Builder monitoringSchedules(Collection<MonitoringSchedule> monitoringSchedules) {
            this.monitoringSchedules = MonitoringScheduleListCopier.copy(monitoringSchedules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringSchedules(MonitoringSchedule ... monitoringSchedules) {
            this.monitoringSchedules(Arrays.asList(monitoringSchedules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder monitoringSchedules(Consumer<MonitoringSchedule.Builder> ... monitoringSchedules) {
            this.monitoringSchedules(Stream.of(monitoringSchedules).map(c -> (MonitoringSchedule)((MonitoringSchedule.Builder)MonitoringSchedule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Endpoint build() {
            return new Endpoint(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Endpoint> {
        public Builder endpointName(String var1);

        public Builder endpointArn(String var1);

        public Builder endpointConfigName(String var1);

        public Builder productionVariants(Collection<ProductionVariantSummary> var1);

        public Builder productionVariants(ProductionVariantSummary ... var1);

        public Builder productionVariants(Consumer<ProductionVariantSummary.Builder> ... var1);

        public Builder dataCaptureConfig(DataCaptureConfigSummary var1);

        default public Builder dataCaptureConfig(Consumer<DataCaptureConfigSummary.Builder> dataCaptureConfig) {
            return this.dataCaptureConfig((DataCaptureConfigSummary)((DataCaptureConfigSummary.Builder)DataCaptureConfigSummary.builder().applyMutation(dataCaptureConfig)).build());
        }

        public Builder endpointStatus(String var1);

        public Builder endpointStatus(EndpointStatus var1);

        public Builder failureReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder monitoringSchedules(Collection<MonitoringSchedule> var1);

        public Builder monitoringSchedules(MonitoringSchedule ... var1);

        public Builder monitoringSchedules(Consumer<MonitoringSchedule.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

