/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelBiasJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary;

public class ListModelBiasJobDefinitionsIterable
implements SdkIterable<ListModelBiasJobDefinitionsResponse> {
    private final SageMakerClient client;
    private final ListModelBiasJobDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelBiasJobDefinitionsIterable(SageMakerClient client, ListModelBiasJobDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListModelBiasJobDefinitionsResponseFetcher();
    }

    public Iterator<ListModelBiasJobDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MonitoringJobDefinitionSummary> jobDefinitionSummaries() {
        Function<ListModelBiasJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobDefinitionSummaries() != null) {
                return response.jobDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelBiasJobDefinitionsResponseFetcher
    implements SyncPageFetcher<ListModelBiasJobDefinitionsResponse> {
        private ListModelBiasJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelBiasJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelBiasJobDefinitionsResponse nextPage(ListModelBiasJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListModelBiasJobDefinitionsIterable.this.client.listModelBiasJobDefinitions(ListModelBiasJobDefinitionsIterable.this.firstRequest);
            }
            return ListModelBiasJobDefinitionsIterable.this.client.listModelBiasJobDefinitions((ListModelBiasJobDefinitionsRequest)((Object)ListModelBiasJobDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

