/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.TrialComponentPrimaryStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrialComponentStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrialComponentStatus> {
    private static final SdkField<String> PRIMARY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryStatus").getter(TrialComponentStatus.getter(TrialComponentStatus::primaryStatusAsString)).setter(TrialComponentStatus.setter(Builder::primaryStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryStatus").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(TrialComponentStatus.getter(TrialComponentStatus::message)).setter(TrialComponentStatus.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_STATUS_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String primaryStatus;
    private final String message;

    private TrialComponentStatus(BuilderImpl builder) {
        this.primaryStatus = builder.primaryStatus;
        this.message = builder.message;
    }

    public final TrialComponentPrimaryStatus primaryStatus() {
        return TrialComponentPrimaryStatus.fromValue(this.primaryStatus);
    }

    public final String primaryStatusAsString() {
        return this.primaryStatus;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrialComponentStatus)) {
            return false;
        }
        TrialComponentStatus other = (TrialComponentStatus)obj;
        return Objects.equals(this.primaryStatusAsString(), other.primaryStatusAsString()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"TrialComponentStatus").add("PrimaryStatus", (Object)this.primaryStatusAsString()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PrimaryStatus": {
                return Optional.ofNullable(clazz.cast(this.primaryStatusAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrialComponentStatus, T> g) {
        return obj -> g.apply((TrialComponentStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String primaryStatus;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(TrialComponentStatus model) {
            this.primaryStatus(model.primaryStatus);
            this.message(model.message);
        }

        public final String getPrimaryStatus() {
            return this.primaryStatus;
        }

        public final void setPrimaryStatus(String primaryStatus) {
            this.primaryStatus = primaryStatus;
        }

        @Override
        @Transient
        public final Builder primaryStatus(String primaryStatus) {
            this.primaryStatus = primaryStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder primaryStatus(TrialComponentPrimaryStatus primaryStatus) {
            this.primaryStatus(primaryStatus == null ? null : primaryStatus.toString());
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public TrialComponentStatus build() {
            return new TrialComponentStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrialComponentStatus> {
        public Builder primaryStatus(String var1);

        public Builder primaryStatus(TrialComponentPrimaryStatus var1);

        public Builder message(String var1);
    }
}

